/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import org.openqa.selenium.By;

public class EditFileCommitDialog
extends Dialog2 {
    public EditFileCommitDialog(By locator) {
        super(locator);
    }

    public EditFileCommitDialog(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public EditFileCommitDialog(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public void clickCancelLink() {
        this.getCancelLink().click();
        this.waitUntilDismissed();
        this.waitUntilBlanketHidden();
    }

    public PageElement getBranchNameTextbox() {
        return this.find(By.id((String)"branch-name"));
    }

    public PageElement getCommitLink() {
        return this.find(By.className((String)"commit-button"));
    }

    public PageElement getCommitTextbox() {
        return this.find(By.id((String)"commit-message"));
    }

    public AuiCheckbox getCreatePrCheckbox() {
        return ElementUtils.findCheckbox((PageElementFinder)this, By.id((String)"create-pr-checkbox"));
    }

    public void setCommitMessage(String commitMessage) {
        this.find(By.className((String)"CodeMirror")).javascript().execute("arguments[0].CodeMirror.setValue('" + commitMessage.replace("\n", "\\n").replace("\t", "\\t").replace("'", "\\'") + "');", new Object[0]);
    }

    public void toggleCreatePrCheckbox(boolean checked) {
        AuiCheckbox checkbox = this.getCreatePrCheckbox();
        if (checkbox.isSelected() != checked) {
            checkbox.click();
        }
    }

    private PageElement getCancelLink() {
        return this.find(By.className((String)"cancel-button"));
    }
}

