/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.By;

public class AuiForm
extends LegacyElementPageObject {
    public static final By SELECTOR = By.cssSelector((String)"form.aui");

    public AuiForm(PageElement pageElement) {
        super(pageElement);
    }

    public AuiForm(By locator) {
        super(locator);
    }

    public AuiForm(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public AuiForm(By locator, WebDriverLocatable parent) {
        super(locator, parent);
    }

    public AuiForm(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, parent, timeoutType);
    }

    public AuiForm(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public String getFieldValue(String fieldName) {
        return this.find(By.cssSelector((String)("input[name='" + fieldName + "']"))).getValue();
    }

    public AuiForm setFieldValue(String fieldName, String fieldValue) {
        this.find(By.cssSelector((String)("input[name='" + fieldName + "']"))).clear().type(new CharSequence[]{fieldValue});
        return this;
    }

    public AuiForm checkFieldValue(String fieldName) {
        this.find(By.cssSelector((String)("input[name='" + fieldName + "']"))).click();
        return this;
    }

    public boolean hasErrors() {
        return this.findAll(By.className((String)"error")).size() != 0;
    }

    public boolean hasFieldErrors(String fieldName) {
        return this.getFieldErrors(fieldName).size() != 0;
    }

    public List<String> getErrors() {
        return this.getErrors(By.className((String)"aui-message-error"));
    }

    public List<String> getFieldErrors(String fieldName) {
        return this.getErrors(By.cssSelector((String)("input[name='" + fieldName + "'] ~ .error")));
    }

    private List<String> getErrors(By locator) {
        return Lists.newArrayList((Iterable)Lists.transform((List)this.findAll(locator), (Function)new Function<PageElement, String>(){

            public String apply(PageElement input) {
                return input.getText().trim();
            }
        }));
    }

    public <T> T submit(Class<T> klass, Object ... args) {
        PageElement submitButton = this.find(By.cssSelector((String)"input.aui-button[type='submit']"));
        Poller.waitUntilTrue((String)"The submit button for the form should be enabled", (TimedQuery)Conditions.forSupplier((long)500L, () -> ((PageElement)submitButton).isEnabled()));
        submitButton.click();
        return (T)this.pageBinder.bind(klass, args);
    }

    public <T> T cancel(Class<T> klass, Object ... args) {
        this.find(By.cssSelector((String)"a.cancel")).click();
        return (T)this.pageBinder.bind(klass, args);
    }

    public boolean hasFieldError(String fieldName) {
        String attr = this.find(By.cssSelector((String)("input[name='" + fieldName + "']"))).getAttribute("data-aui-validate-state");
        return attr != null && attr.equals("invalid");
    }
}

