/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.permissions;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class PermissionFilter
extends AbstractElementPageObject {
    public PermissionFilter(@Nonnull PageElement container) {
        super(container);
    }

    public TimedQuery<List<PageElement>> getSelectedPermissions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.className((String)"permission-filter__multi-value")));
    }

    public PermissionFilter togglePermission(String permission) {
        this.getDropdown().click();
        Poller.waitUntilTrue((TimedQuery)this.container.find(By.className((String)"permission-filter__option")).timed().isVisible());
        ((List)Poller.waitUntil(this.getOptions(), (Matcher)CoreMatchers.hasItem((Matcher)PageElementMatchers.withText((String)permission)))).stream().filter(p -> permission.equals(p.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("%s not found in the permission filter drop-down", permission))).click();
        this.getDropdown().click();
        Poller.waitUntilFalse((TimedQuery)this.container.find(By.className((String)"permission-filter__option")).timed().isVisible());
        return this;
    }

    private TimedQuery<List<PageElement>> getOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.className((String)"permission-filter__option")));
    }

    private PageElement getDropdown() {
        return this.container.find(By.cssSelector((String)"span[aria-label='open']"));
    }
}

