/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class UserMultiSelector
extends AbstractElementPageObject {
    private final PageElement input = this.find(By.tagName((String)"input"));
    @Inject
    private PageElementFinder elementFinder;

    public UserMultiSelector(@Nonnull PageElement container) {
        super(container);
    }

    public UserMultiSelector addUser(String name) {
        this.search(name).selectFirstOption();
        return this;
    }

    public UserMultiSelector closeMenu() {
        this.container.click();
        return this;
    }

    public List<String> getUserNames() {
        return (List)this.getValues().stream().map(Value::getName).collect(MoreCollectors.toImmutableList());
    }

    public List<Value> getValues() {
        return (List)this.container.findAll(By.className((String)"user-multi-select__multi-value")).stream().map(ElementUtils.bind(this.pageBinder, Value.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    public UserMultiSelector removeUser(String name) {
        Optional<Value> reviewer = this.getValues().stream().filter(value -> value.getName().equalsIgnoreCase(name)).findFirst();
        reviewer.get().remove();
        return this;
    }

    public Menu search(String name) {
        this.container.click();
        this.input.clear();
        this.input.type(new CharSequence[]{name});
        this.waitUntilReady();
        PageElement optionsMenu = this.elementFinder.find(By.className((String)"user-multi-select__menu"));
        return (Menu)this.pageBinder.bind(Menu.class, new Object[]{optionsMenu});
    }

    public void waitUntilReady() {
        PageElement spinner = this.elementFinder.find(By.cssSelector((String)".user-multi-select__indicators > div:not(.user-multi-select__clear-indicator) circle"));
        Poller.waitUntilFalse((TimedQuery)spinner.timed().isPresent());
    }

    public static class Menu
    extends AbstractElementPageObject {
        private final PageElement noResults = this.find(By.cssSelector((String)"[data-test-value='no-value']"));

        public Menu(@Nonnull PageElement container) {
            super(container);
            Poller.waitUntilTrue((TimedQuery)container.timed().isVisible());
        }

        public List<PageElement> getOptions() {
            return this.container.findAll(By.cssSelector((String)"[data-testid='option']"));
        }

        public boolean hasNoResults() {
            return this.noResults.isPresent();
        }

        public void selectFirstOption() {
            this.find(By.cssSelector((String)"[data-testid='option']")).click();
            Poller.waitUntilFalse((TimedQuery)this.container.timed().isVisible());
        }
    }

    public static class Value
    extends AbstractElementPageObject {
        private final PageElement name = this.find(By.className((String)"user-name"));
        private final PageElement removeButton = this.find(By.className((String)"user-multi-select__multi-value__remove"));

        public Value(@Nonnull PageElement container) {
            super(container);
        }

        public String getName() {
            return this.name.getText();
        }

        public void remove() {
            String name = this.getName();
            this.removeButton.click();
            Poller.waitUntilTrue((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, () -> !this.container.isPresent() || !this.getName().equals(name)));
        }
    }
}

