/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.page.PullRequestCommitDiffPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestDiffPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestEffectiveDiffPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestIterativeDiffPage;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.hamcrest.MatcherAssert;
import org.openqa.selenium.By;

public class DiffCommitSelector
extends AbstractElementPageObject {
    @Inject
    protected PageElementFinder elementFinder;

    public DiffCommitSelector(@Nonnull PageElement container) {
        super(container);
    }

    public List<CommitItem> getCommits() {
        return this.elementFinder.findAll(By.className((String)"specific-commit-option")).stream().map(ElementUtils.bind(this.pageBinder, CommitItem.class, new Object[0])).collect(Collectors.toList());
    }

    public List<SelectorItem> getItems() {
        return this.elementFinder.findAll(By.cssSelector((String)".commit-selector__menu span.commit-option-wrapper")).stream().map(element -> {
            if (element.hasClass("specific-commit-option")) {
                return (SelectorItem)this.pageBinder.bind(CommitItem.class, new Object[]{element});
            }
            return (SelectorItem)this.pageBinder.bind(MultiCommitItem.class, new Object[]{element});
        }).collect(Collectors.toList());
    }

    public String getSelectedValueDescription() {
        return this.find(By.cssSelector((String)"[data-testid='selected-value-description']")).getText();
    }

    public String getSelectedValueLabel() {
        return this.find(By.cssSelector((String)"[data-testid='selected-value-label']")).getText();
    }

    public TimedCondition isLoading() {
        return this.find(By.cssSelector((String)".commit-selector__indicators circle")).timed().isPresent();
    }

    public DiffCommitSelector open() {
        Poller.waitUntilFalse((TimedQuery)this.isLoading());
        PageElement menuElement = this.elementFinder.find(By.className((String)"commit-selector__menu"));
        if (menuElement.isPresent()) {
            return this;
        }
        this.find(By.className((String)"commit-selector__dropdown-indicator")).click();
        Poller.waitUntilTrue((TimedQuery)menuElement.timed().isPresent());
        return this;
    }

    public void scrollToBottom() {
        this.container.javascript().execute("commitSelector = document.querySelector('.commit-selector__menu-list');commitSelector.scrollTop = commitSelector.scrollHeight;commitSelector.dispatchEvent(new WheelEvent('wheel', { deltaY: 10 }));", new Object[0]);
        Poller.waitUntilFalse((TimedQuery)this.isLoading());
    }

    public PullRequestEffectiveDiffPage selectAllChanges(PullRequestDiffPage page) {
        this.getItems().get(0).click();
        return (PullRequestEffectiveDiffPage)this.pageBinder.bind(PullRequestEffectiveDiffPage.class, new Object[]{page.getProjectKey(), page.getSlug(), page.getPullRequestId()});
    }

    public PullRequestCommitDiffPage selectCommit(PullRequestDiffPage page, String commitHash) {
        Optional<CommitItem> commit = this.getCommits().stream().filter(i -> i.getCommitHash().equals(commitHash)).findFirst();
        MatcherAssert.assertThat((String)"The commit to select should be in the commit list", (boolean)commit.isPresent());
        commit.get().click();
        return (PullRequestCommitDiffPage)this.pageBinder.bind(PullRequestCommitDiffPage.class, new Object[]{page.getProjectKey(), page.getSlug(), page.getPullRequestId(), commitHash});
    }

    public PullRequestIterativeDiffPage selectUnreviewedCommits(PullRequestDiffPage page, String sinceCommit, String untilCommit) {
        this.getItems().get(1).click();
        return (PullRequestIterativeDiffPage)this.pageBinder.bind(PullRequestIterativeDiffPage.class, new Object[]{page.getProjectKey(), page.getSlug(), page.getPullRequestId(), sinceCommit, untilCommit});
    }

    public static class CommitItem
    extends SelectorItem {
        public CommitItem(@Nonnull PageElement container) {
            super(container);
        }

        public int getCommentCount() {
            return Integer.parseInt(this.find(By.className((String)"comment-icon-wrapper")).getText());
        }

        public String getCommitAuthor() {
            return this.find(By.cssSelector((String)".author-and-committer-data .user-name")).getText();
        }

        public String getCommitHash() {
            return this.getCommitHashElement().getAttribute("data-testid");
        }

        public String getCommitMessageSubject() {
            return this.find(By.className((String)"message-subject")).getText();
        }

        public String getDisplayCommitHash() {
            return this.getCommitHashElement().getText();
        }

        private PageElement getCommitHashElement() {
            return this.find(By.className((String)"metadata-hash"));
        }
    }

    public static abstract class SelectorItem
    extends AbstractElementPageObject {
        public SelectorItem(@Nonnull PageElement container) {
            super(container);
        }

        public void click() {
            this.container.click();
        }
    }

    public static class MultiCommitItem
    extends SelectorItem {
        public MultiCommitItem(@Nonnull PageElement container) {
            super(container);
        }

        public String getDescription() {
            return this.find(By.className((String)"metadata-wrapper")).getText();
        }

        public String getTitle() {
            return this.find(By.className((String)"message-wrapper")).getText();
        }
    }
}

