/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.repository.sync;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.repository.sync.RefSyncBanner;
import com.atlassian.webdriver.bitbucket.page.repository.sync.RefSyncDialog;
import com.atlassian.webdriver.bitbucket.util.DateUtils;
import com.atlassian.webdriver.utils.by.ByDataAttribute;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class RefSyncSettingsPage
extends BitbucketPage {
    private final String projectKey;
    private final String repositorySlug;
    @ElementBy(id="enable-ref-syncing")
    private AuiCheckbox enableRefSyncCheckbox;
    @ElementBy(className="not-available")
    private PageElement notAvailable;
    @ElementBy(className="sync-status")
    private PageElement syncStatus;

    public RefSyncSettingsPage(String projectKey, String repositorySlug) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    @Nonnull
    public RefSyncBanner getBanner() {
        return (RefSyncBanner)this.pageBinder.bind(RefSyncBanner.class, new Object[0]);
    }

    @Nonnull
    public Iterable<DivergedBranch> getDivergedBranches() {
        PageElement divergedRefs = this.syncStatus.find(By.className((String)"diverged-refs"));
        if (((Boolean)divergedRefs.timed().isPresent().byDefaultTimeout()).booleanValue()) {
            List rows = divergedRefs.findAll(By.tagName((String)"tr"));
            return Chainable.chain((Iterable)rows).transform(element -> (DivergedBranch)this.pageBinder.bind(DivergedBranch.class, new Object[]{element})).toList();
        }
        return Collections.emptyList();
    }

    @Nullable
    public Instant getLastSync() {
        PageElement lastSync = this.syncStatus.find(By.className((String)"last-sync"));
        if (((Boolean)lastSync.timed().isPresent().byDefaultTimeout()).booleanValue()) {
            String time = lastSync.find(By.tagName((String)"time")).getAttribute("datetime");
            return DateUtils.parseServerTimestamp(time).toInstant();
        }
        return null;
    }

    @Nullable
    public String getNotAvailableMessage() {
        return (Boolean)this.notAvailable.timed().isPresent().byDefaultTimeout() != false ? this.notAvailable.getText() : null;
    }

    @Nonnull
    public String getUrl() {
        return String.format("/plugins/servlet/sync/%1$s/%2$s", this.projectKey, this.repositorySlug);
    }

    public boolean hasStatus() {
        return (Boolean)this.syncStatusIsPresent().byDefaultTimeout();
    }

    public boolean isAvailable() {
        return (Boolean)this.notAvailable.timed().isPresent().byDefaultTimeout() == false;
    }

    public boolean isEnabled() {
        return (Boolean)this.enableRefSyncCheckbox.timed().isSelected().byDefaultTimeout();
    }

    public boolean hasEnableCheckbox() {
        return (Boolean)this.enableRefSyncCheckbox.timed().isPresent().byDefaultTimeout();
    }

    public RefSyncSettingsPage setEnabled(boolean enabled) {
        if (enabled) {
            this.enableRefSyncCheckbox.check();
            Poller.waitUntilTrue((TimedQuery)this.syncStatusIsPresent());
        } else if (this.isEnabled()) {
            this.enableRefSyncCheckbox.uncheck();
            Poller.waitUntilFalse((TimedQuery)this.syncStatusIsPresent());
        }
        return this;
    }

    private TimedCondition syncStatusIsPresent() {
        return this.syncStatus.timed().isPresent();
    }

    public static class DivergedBranch {
        private final PageElement row;
        @Inject
        private PageBinder pageBinder;

        public DivergedBranch(PageElement row) {
            this.row = row;
        }

        @Nonnull
        public String getName() {
            return (String)this.row.find(ByDataAttribute.byData((String)"column", (String)"ref-name")).find(By.cssSelector((String)".ref .name")).timed().getText().byDefaultTimeout();
        }

        @Nonnull
        public RefSyncDialog synchronize() {
            this.row.find(By.className((String)"synchronize-ref")).click();
            RefSyncDialog dialog = (RefSyncDialog)((Object)this.pageBinder.bind(RefSyncDialog.class, new Object[0]));
            Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
            return dialog;
        }
    }
}

