/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.autodecline;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public abstract class AbstractAutoDeclineSettingsPage
extends BaseSidebarPage {
    private final ImmutableMap<Integer, Integer> WEEKS_MAPPING = ImmutableMap.of((Object)1, (Object)0, (Object)2, (Object)1, (Object)4, (Object)2, (Object)8, (Object)3, (Object)12, (Object)4);
    @ElementBy(id="auto-decline-settings")
    private PageElement autoDeclineSettingsContainer;
    @ElementBy(cssSelector="[data-testid=\"cancel-button\"]")
    private PageElement cancelButton;
    @ElementBy(cssSelector="[data-testid=\"inactivity-weeks--trigger\"]")
    private PageElement dropdown;
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(cssSelector="input[type=\"checkbox\"]")
    private PageElement enabledCheckbox;
    @ElementBy(cssSelector="[data-testid=\"enabled-checkbox--checkbox-label\"]")
    private PageElement enabledCheckboxLabel;
    @ElementBy(cssSelector="[data-testid=\"save-button\"]")
    private PageElement saveButton;

    public PageElement getCancelButton() {
        return this.cancelButton;
    }

    public TimedQuery<List<PageElement>> getDropdownOptions() {
        List menuItems = this.elementFinder.findAll(By.cssSelector((String)"button[role=\"menuitem\"]"));
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)menuItems.stream().collect(MoreCollectors.toImmutableList()));
    }

    public int getInactivityWeeks() {
        return Integer.parseInt(this.dropdown.getText().split(" ")[0]);
    }

    public AbstractAutoDeclineSettingsPage setInactivityWeeks(int weeks) {
        this.dropdown.click();
        Poller.waitUntil(this.getDropdownOptions(), (Matcher)Matchers.iterableWithSize((int)5));
        List dropDownOptions = (List)this.getDropdownOptions().now();
        ((PageElement)dropDownOptions.get((Integer)this.WEEKS_MAPPING.get((Object)weeks))).click();
        return this;
    }

    public PageElement getSaveButton() {
        return this.saveButton;
    }

    public boolean isAutoDeclineEnabled() {
        return this.enabledCheckbox.isSelected();
    }

    public boolean isCheckboxEnabled() {
        return this.enabledCheckbox.isEnabled();
    }

    public boolean isComponentLoaded() {
        return this.autoDeclineSettingsContainer.isPresent();
    }

    public boolean isDropdownEnabled() {
        return this.dropdown.isEnabled();
    }

    public AbstractAutoDeclineSettingsPage save() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isEnabled());
        this.saveButton.click();
        return this;
    }

    public AbstractAutoDeclineSettingsPage toggleEnabled() {
        this.enabledCheckboxLabel.click();
        return this;
    }
}

