/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.users;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class LastActiveSelector
extends AbstractElementPageObject {
    @Inject
    private PageElementActions actions;

    public LastActiveSelector(@Nonnull PageElement container) {
        super(container);
    }

    public void chooseFromEndOfNextMonth() {
        this.getFromDatePicker();
        this.container.find(By.cssSelector((String)"[data-testid='admin-user-from-date-picker--calendar--next-month']")).click();
        List dates = this.container.find(By.cssSelector((String)"[data-testid='admin-user-from-date-picker--calendar--container']")).findAll(By.tagName((String)"button")).stream().collect(Collectors.toList());
        ((PageElement)dates.get(dates.size() - 1)).click();
    }

    public void chooseFromToday() {
        PageElement datePicker = this.getFromDatePicker();
        datePicker.find(By.cssSelector((String)"button[data-today='true']")).click();
    }

    public void chooseToEndOfNextMonth() {
        this.getToDatePicker();
        this.container.find(By.cssSelector((String)"[data-testid='admin-user-to-date-picker--calendar--next-month']")).click();
        List dates = this.container.find(By.cssSelector((String)"[data-testid='admin-user-to-date-picker--calendar--container']")).findAll(By.tagName((String)"button")).stream().collect(Collectors.toList());
        ((PageElement)dates.get(dates.size() - 1)).click();
    }

    public void chooseToToday() {
        PageElement datePicker = this.getToDatePicker();
        datePicker.find(By.cssSelector((String)"button[data-today='true']")).click();
    }

    public void clearFromDate() {
        this.getFromDatePicker();
        this.actions.sendKeys(new CharSequence[]{Keys.DELETE}).perform();
    }

    public void clearToDate() {
        this.getToDatePicker();
        this.actions.sendKeys(new CharSequence[]{Keys.DELETE}).perform();
    }

    private PageElement getFromDatePicker() {
        return this.container.find(By.cssSelector((String)"[data-testid='admin-user-from-date-picker--container']")).click();
    }

    private PageElement getToDatePicker() {
        return this.container.find(By.cssSelector((String)"[data-testid='admin-user-to-date-picker--container']")).click();
    }

    public TimedQuery<Boolean> invalidDatesSelected() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.find(By.cssSelector((String)"[data-testid='invalid-dates']")).isPresent());
    }
}

