/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorsAdminPage;
import org.openqa.selenium.By;

public class AbstractMirrorConfigPage
extends BitbucketPage {
    protected static final String PROJECT_SELECTOR = ".project-selector .selector input";
    protected static final String TAB_MIRROR_NODES = "Nodes";
    protected static final String TAB_PROJECTS = "Setup";
    private static final String DELETE_BUTTON_TEXT = "Delete";
    protected final String mirrorId;
    protected final String type;
    private final String url;
    @ElementBy(cssSelector=".mirrors-dashboard-link a")
    private PageElement backToDashboardLink;
    @ElementBy(xpath="//*[@id='mirroring-upstream-container']//button[contains(.,'Delete')]")
    private PageElement deleteButton;
    @ElementBy(cssSelector=".mirror-tabs")
    private PageElement tabs;

    public AbstractMirrorConfigPage(String type, String mirrorId) {
        this.type = type;
        this.mirrorId = mirrorId;
        this.url = "/plugins/servlet/admin/mirrors/" + this.type + "/" + this.mirrorId;
    }

    public MirrorsAdminPage backToDashboard() {
        this.backToDashboardLink.click();
        return (MirrorsAdminPage)this.pageBinder.bind(MirrorsAdminPage.class, new Object[0]);
    }

    public MirrorsAdminPage delete() {
        this.deleteButton.click();
        this.elementFinder.find(By.xpath((String)"//*[@role='dialog']//button[contains(.,'Delete')]")).click();
        return (MirrorsAdminPage)this.pageBinder.bind(MirrorsAdminPage.class, new Object[0]);
    }

    @WaitUntil
    public void ensurePageLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.deleteButton.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.tabs.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
    }

    public String getUrl() {
        return this.url;
    }

    public MirrorsAdminPage goToOverview() {
        this.elementFinder.find(By.cssSelector((String)"#mirroring-upstream-container a[href$=\"/plugins/servlet/admin/mirrors\"]")).click();
        return (MirrorsAdminPage)this.pageBinder.bind(MirrorsAdminPage.class, new Object[0]);
    }

    protected <T extends AbstractMirrorConfigPage> T switchToTab(Class<T> pageClass) {
        this.elementFinder.find(By.cssSelector((String)"[data-testid='nodes-overview']")).click();
        return (T)((AbstractMirrorConfigPage)this.pageBinder.bind(pageClass, new Object[]{this.type, this.mirrorId}));
    }
}

