/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.admin.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.hamcrest.OptionalMatcher;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.admin.ratelimit.ManageUserExemptionDialog;
import com.atlassian.webdriver.bitbucket.page.admin.ratelimit.RateLimitExemptionsPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class UserExemptionsTable
extends AbstractElementPageObject {
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(cssSelector="div.paged-table-container > table.paged-table")
    private PageElement exemptionsTable;
    @ElementBy(cssSelector="div.paged-table-filter > input.paged-table-filter-input")
    private PageElement filterInput;

    public UserExemptionsTable(@Nonnull PageElement container) {
        super(container);
    }

    @Nonnull
    public UserExemptionsTable clearFilter() {
        ElementUtils.waitUntilUpdated(this.exemptionsTable, () -> this.filterInput.clear().type(new CharSequence[]{" "}).clear());
        return this;
    }

    @Nonnull
    public TimedQuery<List<UserExemption>> getExemptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.exemptionsTable.findAll(By.cssSelector((String)"tbody > tr")).stream().map(ElementUtils.bind(this.pageBinder, UserExemption.class, this.elementFinder)).collect(MoreCollectors.toImmutableList()));
    }

    public TimedCondition isVisible() {
        return this.container.timed().isVisible();
    }

    @Nonnull
    public UserExemptionsTable setFilter(@Nonnull String filter) {
        ElementUtils.waitUntilUpdated(this.exemptionsTable, () -> this.filterInput.clear().type(new CharSequence[]{Objects.requireNonNull(filter, "filter")}));
        return this;
    }

    public static class UserExemption
    extends AbstractElementPageObject {
        private static final String UNLIMITED_TEXT = "Unlimited";
        private final PageElementFinder parentElementFinder;

        public UserExemption(@Nonnull PageElement container, @Nonnull PageElementFinder parentElementFinder) {
            super(container);
            this.parentElementFinder = Objects.requireNonNull(parentElementFinder, "parent");
        }

        public RateLimitExemptionsPage delete() {
            this.selectAction("a.delete");
            ElementUtils.waitUntilVisible(this.parentElementFinder.find(By.cssSelector((String)"button.revoke")), this.timeouts).click();
            return (RateLimitExemptionsPage)this.pageBinder.bind(RateLimitExemptionsPage.class, new Object[0]);
        }

        public ManageUserExemptionDialog edit() {
            this.selectAction("a.edit");
            return (ManageUserExemptionDialog)this.pageBinder.bind(ManageUserExemptionDialog.class, new Object[]{this.parentElementFinder});
        }

        @Nonnull
        public TimedQuery<Optional<TokenBucketSettings>> getSettings() {
            return Queries.forSupplier((Timeouts)this.timeouts, () -> {
                String maxTokens = this.getMaxTokens();
                String replacementRate = this.getReplacementRate();
                if (UNLIMITED_TEXT.equalsIgnoreCase(maxTokens) && UNLIMITED_TEXT.equalsIgnoreCase(replacementRate)) {
                    return Optional.empty();
                }
                if (UNLIMITED_TEXT.equalsIgnoreCase(maxTokens) || UNLIMITED_TEXT.equalsIgnoreCase(replacementRate)) {
                    throw new AssertionError((Object)String.format("%s: either both 'max-tokens' and 'replacement-rate' must be positive integers, or both display '%s' for the case of a 'whitelisted' user (max-tokens=%s, replacement-rate=%s)", this.getUserDisplayName(), UNLIMITED_TEXT, maxTokens, replacementRate));
                }
                try {
                    return Optional.of(new TokenBucketSettings.Builder().capacity(Integer.parseInt(maxTokens)).fillRate(Integer.parseInt(replacementRate)).build());
                }
                catch (IllegalArgumentException e) {
                    throw new AssertionError(String.format("%s: 'max-tokens' (capacity) and 'replacement-rate' (fillRate) must be positive integers (max-tokens='%s', replacement-rate='%s')", this.getUserDisplayName(), maxTokens, replacementRate), e);
                }
            });
        }

        @Nonnull
        public TimedQuery<String> getUserDisplayName() {
            return Queries.forSupplier((Timeouts)this.timeouts, () -> this.getElementText("td.user-display-name > div.user-name"));
        }

        @Nonnull
        public TimedQuery<String> getUsername() {
            return Queries.forSupplier((Timeouts)this.timeouts, () -> this.getElementText("td.user-name"));
        }

        public boolean isFocused() {
            return this.container.hasClass("focused");
        }

        public TimedQuery<Boolean> isWhitelisted() {
            return Queries.forSupplier((Timeouts)this.timeouts, () -> UNLIMITED_TEXT.equalsIgnoreCase(this.getMaxTokens()) && UNLIMITED_TEXT.equalsIgnoreCase(this.getReplacementRate()));
        }

        public String toString() {
            return "UserExemption{userDisplayName=" + (String)this.getUserDisplayName().now() + ", whitelisted=" + this.isWhitelisted().now() + ", tokenBucketSettings=" + this.getSettings().now() + "}";
        }

        @Nonnull
        private String getElementText(String cssSelector) {
            PageElement element = ElementUtils.waitUntilVisible(this.container.find(By.cssSelector((String)cssSelector)), this.timeouts);
            return ((String)Poller.waitUntil((String)String.format("%s: element must contain non-empty text", element), (TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, () -> ((PageElement)element).getText()), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()))).trim();
        }

        @Nonnull
        private String getMaxTokens() {
            return this.getElementText("td.max-tokens");
        }

        @Nonnull
        private String getReplacementRate() {
            return this.getElementText("td.replacement-rate");
        }

        private void selectAction(String s) {
            ElementUtils.waitUntilVisible(this.container.find(By.cssSelector((String)"td.actions > button[type=\"button\"]")), this.timeouts).click();
            ((Optional)Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, () -> this.parentElementFinder.findAll(By.cssSelector((String)s)).stream().filter(PageElement::isVisible).findFirst()), (Matcher)Matchers.not((Matcher)OptionalMatcher.empty()))).ifPresent(PageElement::click);
        }
    }
}

