/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.util;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.util.ScrollInfo;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;

public final class ElementUtils {
    public static final String FIELD_CLASS = "field-group";
    public static final String ERROR_CLASS = "error";
    private static final String ATTR_LATEST_UPDATED = "data-last-updated";
    private static final Predicate<PageElement> FIELD_WITH_ERRORS = field -> Iterables.any((Iterable)field.findAll(By.className((String)ERROR_CLASS)), error -> error.isVisible() && !StringUtils.isBlank((CharSequence)error.getText()));
    private static final Function<PageElement, String> FIELD_IDS = new Function<PageElement, String>(){

        @Override
        public String apply(PageElement field) {
            return field.find(By.tagName((String)"input")).getAttribute("id");
        }
    };
    private static final Function<PageElement, String> TEXT = new Function<PageElement, String>(){

        @Override
        public String apply(PageElement element) {
            return element.getText().trim();
        }
    };

    public static <PO> Function<PageElement, PO> bind(final PageBinder pageBinder, final Class<PO> pageObjectClass, final Object ... extraArgs) {
        return new Function<PageElement, PO>(){

            @Override
            public PO apply(PageElement input) {
                return pageBinder.bind(pageObjectClass, ObjectArrays.concat((Object)input, (Object[])extraArgs));
            }
        };
    }

    public static void disableZeroClipboard(JavascriptExecutor javascriptExecutor) {
        javascriptExecutor.executeScript("if (window.ZeroClipboard) { window.ZeroClipboard.isFlashUnusable = function () { return true; }; }", new Object[0]);
    }

    public static void displayAllDeleteButtons(JavascriptExecutor javascriptExecutor) {
        javascriptExecutor.executeScript("jQuery('.delete-button').css('visibility', 'visible');", new Object[0]);
    }

    private static ScrollInfo fromString(String info) {
        ArrayList partStrs = Lists.newArrayList((Object[])info.split("\\|"));
        ArrayList parts = Lists.newArrayList((Iterable)Iterables.transform((Iterable)partStrs, Integer::parseInt));
        return new ScrollInfo((Integer)parts.get(0), (Integer)parts.get(1), (Integer)parts.get(2), (Integer)parts.get(3), (Integer)parts.get(4), (Integer)parts.get(5));
    }

    public static List<String> getElementTexts(List<PageElement> elements) {
        return Chainable.chain(elements).transform(TEXT).toList();
    }

    public static Iterable<String> getFieldsWithErrors(PageElement form) {
        return Chainable.chain((Iterable)form.findAll(By.className((String)FIELD_CLASS))).filter(FIELD_WITH_ERRORS).transform(FIELD_IDS).toList();
    }

    public static String getHtml(PageElement element) {
        return (String)element.javascript().execute(String.class, "return jQuery(arguments[0]).html()", new Object[0]);
    }

    public static Long getLastUpdated(PageElement element) {
        return NumberUtils.toLong((String)element.getAttribute(ATTR_LATEST_UPDATED), null);
    }

    public static ScrollInfo getScrollInfo(PageElement element) {
        return ElementUtils.fromString((String)element.javascript().execute("var params;var el = arguments[0]; debugger;if (el === window || el === document.documentElement) {    params = [        window.scrollY,        window.scrollX,        document.documentElement.scrollHeight,        document.documentElement.scrollWidth,        document.documentElement.clientHeight,        document.documentElement.clientWidth    ];} else {    params = [        el.scrollTop,        el.scrollLeft,        el.scrollHeight,        el.scrollWidth,        el.clientHeight,        el.clientWidth    ];}return  params.join('|');", new Object[0]));
    }

    public static PageElement makeVisible(PageElement element) {
        element.javascript().execute("jQuery(arguments[0]).css('visibility', 'visible')", new Object[0]);
        return element;
    }

    public static void scrollDocument(PageElement element) {
        ElementUtils.scrollDocument(element, null);
    }

    public static void scrollDocument(PageElement element, Integer scrollTop) {
        String scrollTopString = scrollTop == null ? "document.documentElement.scrollHeight" : scrollTop.toString();
        element.javascript().execute("window.scrollTo(0, " + scrollTopString + ")", new Object[0]);
    }

    public static void scrollDocumentAndWait(PageElement element) {
        ElementUtils.scrollDocumentAndWait(element, null);
    }

    public static void scrollDocumentAndWait(final PageElement element, final Integer scrollTop) {
        ElementUtils.waitUntilUpdated(element, new Runnable(){

            @Override
            public void run() {
                ElementUtils.scrollDocument(element, scrollTop);
            }
        });
    }

    public static PageElement selectContent(PageElement element) {
        return element.type(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{SystemUtils.IS_OS_MAC_OSX ? Keys.COMMAND : Keys.CONTROL, "a"})});
    }

    public static void waitUntilUpdated(PageElement element, Runnable operation) {
        Long lastUpdated = ElementUtils.getLastUpdated(element);
        operation.run();
        ElementUtils.waitUntilUpdated(element, lastUpdated);
    }

    public static void waitUntilUpdated(PageElement element, Long lastUpdated) {
        final long updated = lastUpdated == null ? -1L : lastUpdated;
        Poller.waitUntil((TimedQuery)element.timed().getAttribute(ATTR_LATEST_UPDATED), (Matcher)new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String value) {
                return NumberUtils.toLong((String)value, (Long)-1L) > updated;
            }

            public void describeTo(Description description) {
                description.appendText("more recent than").appendValue((Object)updated);
            }
        });
    }

    public static void waitUntilValueUpdated(PageElement element, Runnable operation) {
        String valueBefore = element.getValue();
        operation.run();
        Poller.waitUntil((String)"Expected value to be updated", (TimedQuery)element.timed().getValue(), (Matcher)Matchers.not((Object)valueBefore));
    }

    public static PageElement scrollIntoView(PageElement element) {
        element.javascript().execute("arguments[0].scrollIntoView();", new Object[0]);
        return element;
    }

    public static PageElement scrollIntoViewIfNeeded(PageElement element) {
        if (!element.isVisible()) {
            ElementUtils.scrollIntoView(element);
        }
        return element;
    }

    public static void uploadFile(PageElement uploadField, String filePath) {
        uploadField.javascript().execute("jQuery(arguments[0]).show()", new Object[0]);
        uploadField.type(new CharSequence[]{filePath});
    }
}

