/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repo;

import com.atlassian.pageobjects.binder.ValidateState;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.CheckboxElement;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.junit.Assert;
import org.openqa.selenium.By;

public class BranchModelSettingsPage
extends BaseRepositoryPage {
    public static final String BUGFIX_TYPE_ID = "BUGFIX";
    public static final String FEATURE_TYPE_ID = "FEATURE";
    public static final String HOTFIX_TYPE_ID = "HOTFIX";
    public static final String RELEASE_TYPE_ID = "RELEASE";
    private static final String DEVELOPMENT = "DEVELOPMENT";
    private static final String PRODUCTION = "PRODUCTION";
    @ElementBy(id="branch-model-on")
    protected PageElement onButton;
    @ElementBy(id="branch-model-off")
    protected PageElement offButton;
    @ElementBy(className="branch-model-settings-form")
    protected PageElement form;
    @ElementBy(id="branch-model-settings-form-submit")
    protected PageElement saveButton;
    @ElementBy(id="auto-merge")
    protected CheckboxElement autoMerge;
    @ElementBy(id="branch-model-reset")
    protected PageElement resetToDefaults;
    @ElementBy(id="branch-model-update-success")
    protected PageElement updateSuccessfulMessage;

    public BranchModelSettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public String getUrl() {
        return "/plugins/servlet/branchmodel/projects/" + this.projectKey + "/repos/" + this.slug;
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.onButton.withTimeout(TimeoutType.PAGE_LOAD).timed().isPresent());
    }

    public boolean isEnabled() {
        return this.onButton.hasAttribute("aria-pressed", "true");
    }

    public TimedCondition isAutoMergeEnabled() {
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.isAutoMergeFieldEnabled(), this.autoMerge.timed().isSelected()});
    }

    public TimedCondition isAutoMergeFieldEnabled() {
        return this.autoMerge.timed().isEnabled();
    }

    public SearchableSelector getDevelopmentSelector() {
        return this.getSelector(DEVELOPMENT);
    }

    public SearchableSelector getProductionSelector() {
        return this.getSelector(PRODUCTION);
    }

    public void clearProductionSelector() {
        this.ensureEnabled();
        this.elementFinder.find(By.cssSelector((String)"#PRODUCTION-trigger ~ .remove-link")).click();
        Poller.waitUntilFalse((TimedQuery)this.getProductionSelector().hasValue());
    }

    public BranchTypeConfigurationField getBranchTypeConfiguration(String branchTypeId) {
        return (BranchTypeConfigurationField)this.pageBinder.bind(BranchTypeConfigurationField.class, new Object[]{branchTypeId});
    }

    public boolean isSuccessfulUpdate() {
        return this.updateSuccessfulMessage.isPresent();
    }

    public BranchModelSettingsPage disable() {
        this.ensureEnabled();
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                BranchModelSettingsPage.this.offButton.click();
            }
        });
        return this.rebind();
    }

    public BranchModelSettingsPage enable() {
        this.ensureDisabled();
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                BranchModelSettingsPage.this.onButton.click();
            }
        });
        return this.rebind();
    }

    public BranchModelSettingsPage disableAutoMerge() {
        Poller.waitUntilTrue((TimedQuery)this.isAutoMergeFieldEnabled());
        this.autoMerge.uncheck();
        return this;
    }

    public BranchModelSettingsPage enableAutoMerge() {
        Poller.waitUntilTrue((TimedQuery)this.isAutoMergeFieldEnabled());
        this.autoMerge.check();
        return this;
    }

    public BranchModelSettingsPage resetToDefaults() {
        this.ensureEnabled();
        this.resetToDefaults.click();
        return this;
    }

    public BranchModelSettingsPage update() {
        this.ensureEnabled();
        this.saveButton.click();
        return this.rebind();
    }

    private void ensureDisabled() {
        Assert.assertFalse((String)"Branch model is currently enabled", (boolean)this.isEnabled());
    }

    private void ensureEnabled() {
        Assert.assertTrue((String)"Branch model is currently not enabled", (boolean)this.isEnabled());
    }

    private SearchableSelector getSelector(String branchId) {
        this.ensureEnabled();
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.elementFinder.find(By.id((String)(branchId + "-trigger"))), By.className((String)("branch-selector-" + branchId)), this.elementFinder.find(By.id((String)branchId))});
    }

    private BranchModelSettingsPage rebind() {
        return (BranchModelSettingsPage)this.pageBinder.bind(BranchModelSettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public static class WithError
    extends BranchModelSettingsPage {
        private final int code;
        private final String expectedMessage;

        public WithError(String projectKey, String slug, int code, String expectedMessage) {
            super(projectKey, slug);
            this.code = code;
            this.expectedMessage = expectedMessage;
        }

        @Override
        public void doWait() {
        }

        @ValidateState
        private void assertIsError() {
            this.assertIsError(this.expectedMessage, this.code);
        }
    }

    public static class BranchTypeConfigurationField {
        @Inject
        private PageElementFinder finder;
        private final String branchTypeId;

        public BranchTypeConfigurationField(String branchTypeId) {
            this.branchTypeId = (String)Preconditions.checkNotNull((Object)branchTypeId);
        }

        public PageElement getPrefixField() {
            return this.getContainer().find(By.id((String)(this.branchTypeId + "-prefix")));
        }

        public CheckboxElement getEnabledField() {
            return (CheckboxElement)this.getContainer().find(By.id((String)(this.branchTypeId + "-enabled")), CheckboxElement.class);
        }

        public String getPrefix() {
            return this.getPrefixField().getValue();
        }

        public TimedCondition isEnabled() {
            return this.getEnabledField().timed().isSelected();
        }

        public BranchTypeConfigurationField enable() {
            this.getEnabledField().check();
            Poller.waitUntilTrue((TimedQuery)this.isEnabled());
            return this;
        }

        public BranchTypeConfigurationField disable() {
            this.getEnabledField().uncheck();
            Poller.waitUntilFalse((TimedQuery)this.isEnabled());
            return this;
        }

        public BranchTypeConfigurationField setPrefix(String prefix) {
            this.getPrefixField().clear().type(new CharSequence[]{prefix});
            return this;
        }

        @WaitUntil
        private void mustExist() {
            Poller.waitUntilTrue((TimedQuery)this.getContainer().timed().isPresent());
        }

        private PageElement getContainer() {
            return this.finder.find(By.id((String)this.branchTypeId));
        }
    }
}

