/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.GroupDeleteDialog;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.GroupCreatePage;
import com.atlassian.webdriver.bitbucket.page.admin.GroupEditPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import org.openqa.selenium.By;

public class GroupListPage
extends BitbucketPage {
    @ElementBy(className="paged-table-filter-input")
    private PageElement filterTextbox;
    @ElementBy(id="list-groups")
    private PageElement groupList;

    public String getUrl() {
        return "/admin/groups";
    }

    public GroupRow getGroup(String name) {
        for (PageElement row : this.groupList.findAll(Locators.tableRow())) {
            GroupRow groupRow = new GroupRow(row);
            if (!name.equals(groupRow.getName())) continue;
            return groupRow;
        }
        return null;
    }

    public GroupListPage setFilter(final String filter) {
        ElementUtils.waitUntilUpdated(this.groupList, new Runnable(){

            @Override
            public void run() {
                GroupListPage.this.filterTextbox.clear().type(new CharSequence[]{filter});
            }
        });
        return (GroupListPage)this.pageBinder.bind(GroupListPage.class, new Object[0]);
    }

    public boolean hasConfirmationDelete(String groupName) {
        PageElement successMessage = this.elementFinder.find(By.className((String)"aui-message-success"));
        return successMessage.isVisible() && successMessage.getText().contains(groupName) && successMessage.getText().contains("deleted");
    }

    public GroupCreatePage clickCreateGroup() {
        this.elementFinder.find(By.className((String)"create-group-link")).click();
        return (GroupCreatePage)this.pageBinder.bind(GroupCreatePage.class, new Object[0]);
    }

    public class GroupRow {
        private final PageElement row;

        public GroupRow(PageElement row) {
            this.row = row;
        }

        public String getName() {
            PageElement nameColumn = this.getColumn("group");
            return nameColumn.isPresent() ? nameColumn.getText() : null;
        }

        public GroupEditPage clickView() {
            PageElement nameColumn = this.getColumn("group");
            if (nameColumn.isPresent()) {
                nameColumn.find(By.tagName((String)"a")).click();
                return (GroupEditPage)GroupListPage.this.pageBinder.bind(GroupEditPage.class, new Object[0]);
            }
            return null;
        }

        public GroupDeleteDialog clickDelete() {
            ElementUtils.displayAllDeleteButtons(GroupListPage.this.javascriptExecutor);
            PageElement deleteLink = this.getColumn("actions").find(By.className((String)"delete-group-link"));
            deleteLink.click();
            GroupDeleteDialog dialog = (GroupDeleteDialog)GroupListPage.this.body.find(By.id((String)"delete-dialog"), GroupDeleteDialog.class);
            Poller.waitUntilTrue((TimedQuery)dialog.timed().isVisible());
            return dialog;
        }

        private PageElement getColumn(String column) {
            return this.row.find(By.cssSelector((String)("td[headers='" + column + "']")));
        }
    }
}

