/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverCheckboxElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import org.openqa.selenium.By;

public class PullRequestRepositorySettingsPage
extends BaseRepositoryPage {
    @ElementBy(id="requiredApprovers")
    private WebDriverCheckboxElement requiredApprovers;
    @ElementBy(id="requiredApproversCount")
    private PageElement requiredApproversCount;
    @ElementBy(id="requirePullRequestTasksResolved")
    private WebDriverCheckboxElement requireTasksCompletedCheckbox;
    @ElementBy(cssSelector="form.pull-request-settings #submit")
    private PageElement saveButton;

    public PullRequestRepositorySettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings/pull-requests", this.projectKey, this.slug);
    }

    public int getNumberOfRequiredApprovers() {
        if (this.requiredApprovers.isSelected()) {
            return Integer.parseInt(this.requiredApproversCount.getValue());
        }
        return 0;
    }

    public PullRequestRepositorySettingsPage setNumberOfRequiredApprovers(int n) {
        if (n == 0) {
            this.requiredApprovers.uncheck();
        } else {
            this.requiredApprovers.check();
            Poller.waitUntilTrue((TimedQuery)this.requiredApproversCount.timed().isEnabled());
            PageElement option = this.requiredApproversCount.find(By.cssSelector((String)String.format("option[value='%d']", n)));
            if (!option.isPresent()) {
                throw new IllegalArgumentException("Unsupported number of approvers: " + n);
            }
            option.select();
        }
        return this;
    }

    public PullRequestRepositorySettingsPage setRequireTasksCompleted(boolean requireTasksCompleted) {
        if (requireTasksCompleted) {
            this.requireTasksCompletedCheckbox.check();
        } else {
            this.requireTasksCompletedCheckbox.uncheck();
        }
        return this;
    }

    public PullRequestRepositorySettingsPage clickSave() {
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                PullRequestRepositorySettingsPage.this.saveButton.click();
            }
        });
        return (PullRequestRepositorySettingsPage)this.pageBinder.bind(PullRequestRepositorySettingsPage.class, new Object[]{this.projectKey, this.slug});
    }
}

