/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.Option;
import com.atlassian.pageobjects.elements.Options;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.SelectElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.PullRequestTable;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestCreatePage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import org.openqa.selenium.By;

public class PullRequestListPage
extends BaseRepositoryPage {
    private final Map<String, String> filters;
    @ElementBy(id="s2id_pr-author-filter")
    private PageElement authorFilter;
    @ElementBy(id="list-create-pr-button")
    private PageElement createActionButton;
    @ElementBy(id="bitbucket-pull-request-table")
    private PageElement pullRequestTable;
    @ElementBy(id="pr-reviewer-self-filter")
    private PageElement reviewingFilter;
    @ElementBy(id="pr-state-filter")
    private SelectElement stateFilter;
    @ElementBy(id="s2id_pr-target-branch-filter")
    private PageElement targetBranchFilter;

    public PullRequestListPage(String projectKey, String slug) {
        this(projectKey, slug, Maps.newHashMap());
    }

    public PullRequestListPage(String projectKey, String slug, Map<String, String> filters) {
        super(projectKey, slug);
        this.filters = ImmutableMap.copyOf(filters);
    }

    public PullRequestCreatePage clickCreateActionButton() {
        this.createActionButton.click();
        return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.projectKey, this.slug});
    }

    public void filterByAuthor(String author) {
        this.filterByAsyncSelect(this.authorFilter, author, ".avatar-with-name[title=\"" + this.escapeSelector(author) + "\"]");
    }

    public void filterByReviewerToggle() {
        String currentTimestamp = this.getPullRequestTable().getCurrentTimestamp();
        this.reviewingFilter.click();
        this.getPullRequestTable().waitUntilTableIsUpdated(currentTimestamp);
    }

    public void filterByState(PullRequestState state) {
        String currentTimestamp = this.getPullRequestTable().getCurrentTimestamp();
        this.stateFilter.select((Option)Options.value((String)state.name()));
        this.getPullRequestTable().waitUntilTableIsUpdated(currentTimestamp);
    }

    public void filterByTargetBranch(String branch) {
        this.filterByAsyncSelect(this.targetBranchFilter, branch, ".name[title=\"" + this.escapeSelector(branch) + "\"]");
    }

    public PullRequestTable getPullRequestTable() {
        return (PullRequestTable)this.pageBinder.bind(PullRequestTable.class, new Object[]{this.pullRequestTable});
    }

    public PullRequestTable.Entry getPullRequestTableEntry(long pullRequestId) {
        try {
            return (PullRequestTable.Entry)Iterables.find(this.getPullRequestTable().getRows(), row -> pullRequestId == row.getId());
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No pull request with ID " + pullRequestId + " in the list");
        }
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/pull-requests" + this.getQueryString();
    }

    public boolean isBuildStatusColumnVisible() {
        PageElement buildColumn = this.elementFinder.find(By.cssSelector((String)"th.build-status-pr-list-col"));
        return buildColumn.isPresent() && buildColumn.isVisible();
    }

    public boolean isCreateActionButtonVisible() {
        return this.createActionButton.isPresent() && this.createActionButton.isVisible();
    }

    public boolean isGettingStartedMessageVisible() {
        PageElement gettingStartedMessage = this.elementFinder.find(By.cssSelector((String)".paged-table-message .pull-request-intro"));
        return gettingStartedMessage.isPresent() && gettingStartedMessage.isVisible();
    }

    public boolean isNoResultsMessageVisible() {
        PageElement noMoreMessage = this.elementFinder.find(By.cssSelector((String)".paged-table-message .empty-banner-content"));
        return noMoreMessage.isPresent() && noMoreMessage.isVisible();
    }

    public boolean isNoMoreResultsMessageVisible() {
        PageElement noMoreResultsMessage = this.elementFinder.find(By.className((String)"no-more-results"));
        return noMoreResultsMessage.isPresent() && noMoreResultsMessage.isVisible();
    }

    private String escapeSelector(String s) {
        return s.replaceAll("\"", "\\\"");
    }

    private void filterByAsyncSelect(PageElement filter, String value, String resultSelector) {
        String currentTimestamp = this.getPullRequestTable().getCurrentTimestamp();
        filter.find(By.cssSelector((String)"a.select2-choice")).click();
        PageElement searchBox = this.elementFinder.find(By.cssSelector((String)"#select2-drop input"));
        searchBox.click().clear().type(new CharSequence[]{value});
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#select2-drop .spinner .spinner")).timed().isPresent());
        this.elementFinder.find(By.cssSelector((String)("#select2-drop ul.select2-results " + resultSelector))).click();
        this.getPullRequestTable().waitUntilTableIsUpdated(currentTimestamp);
    }

    private String getQueryString() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> entry : this.filters.entrySet()) {
            buffer.append(buffer.length() == 0 ? "?" : "&").append(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return buffer.toString();
    }
}

