/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AUISidebar;
import com.atlassian.webdriver.bitbucket.element.ProjectRepositoryTable;
import com.atlassian.webdriver.bitbucket.page.BaseProjectPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryCreatePage;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ProjectOverviewPage
extends BaseProjectPage {
    private static final String CREATE_REPO_CLASSNAME = "create-repository-link";

    public ProjectOverviewPage(String key) {
        super(key);
    }

    public String getUrl() {
        return String.format("/projects/%s", this.getProjectKey());
    }

    public ProjectRepositoryTable getRepositoryTable() {
        return (ProjectRepositoryTable)((Object)this.pageBinder.bind(ProjectRepositoryTable.class, new Object[]{By.id((String)"repositories-table"), TimeoutType.DEFAULT, this.getProjectKey()}));
    }

    private WebElement getCreateRepositoryButton() {
        List elements;
        AUISidebar sidebar = this.getSidebar();
        if (sidebar.isCollapsed()) {
            sidebar.toggle();
        }
        if ((elements = this.driver.findElements(By.cssSelector((String)".create-repository-link a"))).size() > 0) {
            return (WebElement)elements.get(0);
        }
        return null;
    }

    public boolean canCreateRepository() {
        return this.getCreateRepositoryButton() != null;
    }

    public RepositoryCreatePage clickCreateRepository() {
        if (this.getCreateRepositoryButton() != null) {
            this.getCreateRepositoryButton().click();
            return (RepositoryCreatePage)this.pageBinder.bind(RepositoryCreatePage.class, new Object[]{this.getProjectKey()});
        }
        throw new IllegalStateException("Cannot click create repository button as it does not exist");
    }
}

