/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.webdriver.bitbucket.element.DiffSelectionDropdown;
import com.atlassian.webdriver.bitbucket.element.SideBySideDiffFileContent;
import com.atlassian.webdriver.bitbucket.page.FileContentPage;
import com.atlassian.webdriver.bitbucket.page.FileLayoutPage;
import com.atlassian.webdriver.bitbucket.page.FileUnifiedDiffPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.KeyboardShortcuts;
import org.openqa.selenium.By;

public class FileSideBySideDiffPage
extends FileContentPage<SideBySideDiffFileContent> {
    @ElementBy(className="file-content", pageElementClass=SideBySideDiffFileContent.class)
    protected SideBySideDiffFileContent diffContent;

    public FileSideBySideDiffPage(String projectKey, String repoSlug, String path) {
        super(projectKey, repoSlug, path);
    }

    public FileSideBySideDiffPage(String projectKey, String repoSlug, String path, FileLayoutPage.RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug, path, revisionSpecifier);
    }

    @Override
    public SideBySideDiffFileContent getFileContent() {
        return this.diffContent;
    }

    @Override
    protected String getPathComponent() {
        return "diff";
    }

    public FileSideBySideDiffPage loadUntilRevision(String revision) {
        return this.loadRevision(revision, FileSideBySideDiffPage.class);
    }

    public FileUnifiedDiffPage switchToUnified() {
        ((DiffSelectionDropdown)this.pageBinder.bind(DiffSelectionDropdown.class, new Object[]{this.elementFinder.find(By.id((String)"diff-options-dropdown-trigger"))})).open().selectUnified();
        FileUnifiedDiffPage page = (FileUnifiedDiffPage)this.pageBinder.bind(FileUnifiedDiffPage.class, new Object[]{this.projectKey, this.slug, this.path});
        page.getFileContent().waitUntilFileContentLoaded();
        return page;
    }

    public void moveToNextChange(boolean expectMovement) {
        this.navigateDiff(expectMovement, new Runnable(){

            @Override
            public void run() {
                KeyboardShortcuts.moveToNextSecondary(FileSideBySideDiffPage.this.body);
            }
        });
    }

    public void moveToPreviousChange(boolean expectMovement) {
        this.navigateDiff(expectMovement, new Runnable(){

            @Override
            public void run() {
                KeyboardShortcuts.moveToPreviousSecondary(FileSideBySideDiffPage.this.body);
            }
        });
    }

    private void navigateDiff(boolean expectMovement, Runnable doNavigation) {
        if (expectMovement) {
            ElementUtils.waitUntilUpdated(this.getFileContent().find(By.className((String)"content-view")), doNavigation);
        } else {
            doNavigation.run();
        }
    }
}

