/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.activity;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.webdriver.bitbucket.element.Avatar;
import com.atlassian.webdriver.bitbucket.element.activity.DiffLineCommentActivity;
import com.atlassian.webdriver.bitbucket.element.activity.FileCommentActivity;
import com.atlassian.webdriver.bitbucket.element.activity.GeneralCommentActivity;
import com.atlassian.webdriver.bitbucket.element.activity.StateActivityItem;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public abstract class ActivityItem {
    @Inject
    protected PageBinder pageBinder;
    protected final PageElement activityContainer;

    public ActivityItem(@Nonnull PageElement activityContainer) {
        this.activityContainer = (PageElement)Preconditions.checkNotNull((Object)activityContainer, (Object)"activityContainer");
    }

    @Nonnull
    public static Class<? extends ActivityItem> getType(PageElement element) {
        Class activityItemClass = element.hasClass("general-comment-activity") ? GeneralCommentActivity.class : (element.hasClass("diff-comment-activity") ? DiffLineCommentActivity.class : (element.hasClass("file-comment-activity") ? FileCommentActivity.class : StateActivityItem.getType(element)));
        return activityItemClass;
    }

    @Nonnull
    public Avatar getAvatar() {
        return (Avatar)((Object)this.activityContainer.findAll(By.className((String)"user-avatar"), Avatar.class).get(0));
    }

    public TimedCondition isPresent() {
        return this.activityContainer.timed().isPresent();
    }
}

