/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.GroupOption;
import com.atlassian.webdriver.bitbucket.element.IdOption;
import com.atlassian.webdriver.bitbucket.element.UserOption;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class UserAndGroupOption
extends IdOption {
    @Inject
    protected PageBinder pageBinder;

    public UserAndGroupOption(PageElement container) {
        super(container);
    }

    @Nonnull
    public static Predicate<UserAndGroupOption> idMatches(@Nonnull String id) {
        return IdOption.idMatches(UserAndGroupOption.class, id);
    }

    @Nullable
    public String getDisplayName() {
        if (!this.isUserOption()) {
            return null;
        }
        return this.getUserOption().getDisplayName();
    }

    @Nullable
    public String getGroupName() {
        if (!this.isGroupOption()) {
            return null;
        }
        return this.getGroupOption().getGroupName();
    }

    @Override
    @Nullable
    public String getId() {
        if (this.isGroupOption()) {
            return this.getGroupName();
        }
        if (this.isUserOption()) {
            return this.getUsername();
        }
        throw new AssertionError((Object)("Unrecognized option: " + this));
    }

    @Nullable
    public String getUsername() {
        if (!this.isUserOption()) {
            return null;
        }
        return this.getUserOption().getUsername();
    }

    public boolean isGroupOption() {
        return this.getGroupOption().getGroupContainer().isPresent();
    }

    public boolean isUserOption() {
        return this.getUserOption().getUsernameContainer().isPresent();
    }

    @Nonnull
    protected GroupOption getGroupOption() {
        return (GroupOption)this.pageBinder.bind(GroupOption.class, new Object[]{this.container});
    }

    @Nonnull
    protected UserOption getUserOption() {
        return (UserOption)this.pageBinder.bind(UserOption.class, new Object[]{this.container});
    }

    @Override
    protected void extendToString(Objects.ToStringHelper toStringHelper) {
        toStringHelper.add("id", (Object)this.getId());
    }
}

