/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class RepositoryQuickSearch {
    @ElementBy(id="repository-search")
    private PageElement searchInput;
    @Inject
    private PageBinder pageBinder;

    public Dialog search(String query) {
        this.searchInput.clear();
        this.searchInput.type(new CharSequence[]{query});
        return (Dialog)this.pageBinder.bind(Dialog.class, new Object[]{this.searchInput});
    }

    public static class Result {
        private final String projectKey;
        private final String repoSlug;

        public Result(String projectKey, String repoSlug) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        public String getRepoSlug() {
            return this.repoSlug;
        }
    }

    public static class Dialog {
        protected final PageElement searchInput;
        @ElementBy(className="repository-search-dialog")
        protected PageElement repositorySearchDialog;

        public Dialog(PageElement searchInput) {
            this.searchInput = searchInput;
        }

        @WaitUntil
        public void ready() {
            Poller.waitUntilTrue((TimedQuery)this.repositorySearchDialog.find(By.cssSelector((String)".results-list li")).timed().isVisible());
        }

        public List<Result> getResults() {
            List resultElements = this.repositorySearchDialog.findAll(By.cssSelector((String)".repository-menu-item > a"));
            return new ArrayList<Result>(Collections2.transform((Collection)resultElements, (Function)new Function<PageElement, Result>(){

                public Result apply(PageElement element) {
                    return new Result(element.getAttribute("data-proj-key"), element.getAttribute("data-repo-slug"));
                }
            }));
        }

        public Dialog focusNext() {
            this.searchInput.type(new CharSequence[]{Keys.ARROW_DOWN});
            return this;
        }

        public Dialog focusPrevious() {
            this.searchInput.type(new CharSequence[]{Keys.ARROW_UP});
            return this;
        }

        public void selectFocused() {
            this.repositorySearchDialog.find(By.cssSelector((String)".repository-menu-item.focused > a")).click();
        }

        public boolean isShowingEmptyMessage() {
            PageElement message = this.repositorySearchDialog.find(By.className((String)"no-results"));
            return message.isVisible() && message.getText().toLowerCase().contains("no repositories");
        }
    }
}

