/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.BranchTypeSelector;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.element.UserAndGroupSelect;
import com.atlassian.webdriver.bitbucket.page.admin.repo.BranchPermissionsPage;
import java.util.List;
import org.openqa.selenium.By;

public abstract class PermissionDialog
extends Dialog2 {
    static final String CONTAINER_ID = "branch-permissions-dialog";
    protected final BranchPermissionsPage parent;

    public PermissionDialog(BranchPermissionsPage parent) {
        super(By.id((String)CONTAINER_ID));
        this.parent = parent;
    }

    public abstract BranchPermissionsPage bindParentPage();

    public BranchPermissionsPage cancel() {
        this.clickCancel();
        return this.bindParentPage();
    }

    public BranchPermissionsPage checkBoxes(boolean ... checkBoxes) {
        List<PageElement> checkboxList = this.getCheckboxes();
        int i = 0;
        for (PageElement checkbox : checkboxList) {
            if (checkBoxes.length > i) {
                checkbox.click();
            }
            ++i;
        }
        return this.bindParentPage();
    }

    private List<PageElement> getCheckboxes() {
        return this.findAll(By.cssSelector((String)"input[type='checkbox']"));
    }

    private PageElement getFirstCheckbox() {
        return this.getCheckboxes().get(0);
    }

    public void setFirstCheckbox(boolean checked) {
        PageElement checkbox = this.getCheckboxes().get(0);
        if (checkbox.isSelected() != checked) {
            checkbox.click();
        }
    }

    public BranchTypeSelector getBranchTypeSelector() {
        PageElement selectorTrigger = this.find(By.id((String)"s2id_branch-type-selector"));
        return (BranchTypeSelector)this.pageBinder.bind(BranchTypeSelector.class, new Object[]{selectorTrigger});
    }

    public String getEditSubject() {
        return this.find(By.className((String)"branch-name-text")).getText();
    }

    private UserAndGroupSelect getUsersAndGroupSelectFor(PageElement checkbox) {
        return (UserAndGroupSelect)this.pageBinder.bind(UserAndGroupSelect.class, new Object[]{this.find(By.id((String)("s2id_" + checkbox.getId() + "-input")))});
    }

    public UserAndGroupSelect getFirstUsersAndGroups() {
        return this.getUsersAndGroupSelectFor(this.getFirstCheckbox());
    }

    public BranchPermissionsPage submit() {
        this.clickMainAction();
        this.waitUntilDismissed();
        return this.bindParentPage();
    }

    public boolean submitExpectingError() {
        this.mainActionButton.click();
        return this.find(By.cssSelector((String)".error")).isVisible();
    }

    protected void changeBranchType(String type) {
        ((BranchTypeSelector)this.getBranchTypeSelector().openOptions()).selectOption(type);
    }

    @Override
    By getCancelLinkLocator() {
        return By.id((String)"cancel-permission-button");
    }

    @Override
    By getMainActionLocator() {
        return By.id((String)"save-permission-button");
    }
}

