/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.element.RepositoryTable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class GlobalRepositoryTable
extends RepositoryTable<GlobalRepositoryRow> {
    public GlobalRepositoryTable(@Nonnull PageElement pageElement) {
        super(pageElement, GlobalRepositoryRow.class);
    }

    public GlobalRepositoryTable(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public static class GlobalRepositoryRow
    extends RepositoryTable.RepositoryRow {
        private static final Pattern PROJECT_URL = Pattern.compile("/projects/([^/]+)");

        public GlobalRepositoryRow(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public GlobalRepositoryRow(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        protected LinkElement getProjectLink() {
            return (LinkElement)this.getNameColumn().find(By.cssSelector((String)".project-name a"), LinkElement.class);
        }

        public String getProjectKey() {
            Matcher matcher = PROJECT_URL.matcher(this.getProjectLink().getUrl());
            return matcher.find() ? matcher.group(1) : null;
        }

        public String getProjectName() {
            return this.getProjectLink().getText();
        }

        @Override
        protected LinkElement getRepositoryLink() {
            return (LinkElement)this.getNameColumn().find(By.cssSelector((String)".repository-name a"), LinkElement.class);
        }
    }
}

