/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.branches;

import com.atlassian.bitbucket.pageobjects.page.next.BranchLayoutPage;
import com.atlassian.bitbucket.pageobjects.page.next.ComparePage;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.webdriver.bitbucket.element.BranchDeleteDialog;
import com.atlassian.webdriver.bitbucket.element.BranchList;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.UrlUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class BranchListPage
extends BranchLayoutPage {
    private final String baseRef;
    private final Long lastUpdated;

    public BranchListPage(String projectKey, String repoSlug) {
        this(projectKey, repoSlug, null, null);
    }

    public BranchListPage(String projectKey, String repoSlug, Long lastUpdated) {
        this(projectKey, repoSlug, lastUpdated, null);
    }

    public BranchListPage(String projectKey, String repoSlug, Long lastUpdated, String baseRef) {
        super(projectKey, repoSlug);
        this.baseRef = baseRef;
        this.lastUpdated = lastUpdated;
    }

    public BranchListPage deleteFocusedBranch() {
        this.useShortcut((CharSequence)Keys.DELETE);
        PageElement dialogContainer = this.elementFinder.find(By.cssSelector((String)"[data-testid=\"delete-branch-modal\"]"));
        BranchDeleteDialog dialog = (BranchDeleteDialog)this.pageBinder.bind(BranchDeleteDialog.class, new Object[]{dialogContainer});
        dialog.clickConfirm();
        return this;
    }

    public BranchListPage focusFilter() {
        this.useShortcut("f");
        return this;
    }

    public BranchList getBranchList() {
        return (BranchList)this.pageBinder.bind(BranchList.class, new Object[]{this, this.elementFinder.find(By.id((String)"branch-list")), this.elementFinder.find(By.id((String)"paged-table-input-for-branch-list")), this.lastUpdated});
    }

    public String getMessageText() {
        PageElement message = this.getMessageElement();
        return message.isVisible() ? message.getText() : null;
    }

    public String getUrl() {
        String url = "/projects/" + this.projectKey + "/repos/" + this.slug + "/branches";
        return StringUtils.isEmpty((CharSequence)this.baseRef) ? url : url + "?base=" + UrlUtils.uriEncode(this.baseRef);
    }

    public TimedCondition isModalVisible(String text) {
        return this.elementFinder.find(By.xpath((String)("//*[.=('" + text + "')]"))).timed().isVisible();
    }

    public BranchListPage moveToNextBranch() {
        this.useShortcut("j");
        return this;
    }

    public BranchListPage moveToPreviousBranch() {
        this.useShortcut("k");
        return this;
    }

    public ComparePage openCompare() {
        this.waitForPageLoad(() -> this.useShortcut("o"));
        return (ComparePage)this.pageBinder.bind(ComparePage.class, new Object[]{this.getProjectKey(), this.getSlug(), ComparePage.Tab.COMMITS});
    }

    public BranchListPage switchTo(String branch) {
        Long lastUpdated = ElementUtils.getLastUpdated(this.elementFinder.find(By.id((String)"branch-list")));
        this.getBranchSelector().open().selectItemByName(branch);
        return (BranchListPage)this.pageBinder.bind(BranchListPage.class, new Object[]{this.projectKey, this.slug, lastUpdated, branch});
    }

    private PageElement getMessageElement() {
        return this.elementFinder.find(By.className((String)"branch-list-empty-state"));
    }
}

