/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.ProjectSelector;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.RepositoryManagementPage;
import jakarta.annotation.Nonnull;
import org.openqa.selenium.By;

public class MoveConfirmationDialog
extends AbstractElementPageObject {
    private final RepositoryManagementPage page;

    public MoveConfirmationDialog(@Nonnull RepositoryManagementPage page, @Nonnull PageElement container) {
        super(container);
        this.page = page;
    }

    public RepositoryManagementPage clickCancel() {
        this.container.find(By.id((String)"cancel-move-repository-button")).click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isPresent());
        return this.page;
    }

    public void clickConfirm() {
        this.container.find(By.id((String)"confirm-move-repository-button")).click();
    }

    public String getCloneUrl() {
        return this.container.find(By.cssSelector((String)"[data-testid='clone-url']")).getText();
    }

    public ProjectSelector getProjectSelector() {
        return (ProjectSelector)this.pageBinder.bind(ProjectSelector.class, new Object[]{this.container});
    }

    public String getRepositoryName() {
        return this.repositoryName().getValue();
    }

    public TimedCondition isUrlAlreadyTakenError() {
        return this.container.find(By.cssSelector((String)"[data-testid='url-already-taken']")).timed().isVisible();
    }

    public TimedCondition isVisible() {
        return this.container.timed().isVisible();
    }

    public void setRepositoryName(String repoName) {
        this.repositoryName().clear().type(new CharSequence[]{repoName});
    }

    private PageElement repositoryName() {
        return this.container.find(By.id((String)"repository-name-field"));
    }
}

