/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.utils.WebDriverUtil;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class NavLinksPage
extends BitbucketAdminPage {
    @ElementBy(id="custom-app-admin-content")
    private PageElement tableElement;

    public NavLinksPage() {
    }

    public NavLinksPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public String getUrl() {
        return "/plugins/servlet/customize-application-navigator";
    }

    public void addNavLink(String displayName, String url) {
        this.scrollTable(TableSide.LEFT);
        PageElement createRow = this.tableElement.find(By.cssSelector((String)".aui-restfultable-create tr"));
        PageElement displayNameInput = createRow.find(By.cssSelector((String)".custom-apps-restfultable-displayname input"));
        PageElement urlInput = createRow.find(By.cssSelector((String)"td:nth-child(3) input"));
        displayNameInput.clear().type(new CharSequence[]{displayName});
        urlInput.clear().type(new CharSequence[]{url});
        this.scrollTable(TableSide.RIGHT);
        createRow.find(By.cssSelector((String)".aui-restfultable-operations .aui-button")).click();
        Poller.waitUntilFalse((TimedQuery)createRow.timed().hasClass("loading"));
    }

    public void deleteNavLink(String displayName) {
        this.scrollTable(TableSide.LEFT);
        int index = this.findNavLink(displayName);
        if (index == -1) {
            throw new IllegalArgumentException("No nav link in page with display name '" + displayName + "'");
        }
        PageElement row = this.getTableRows().get(index);
        this.scrollTable(TableSide.RIGHT);
        row.find(By.className((String)"aui-restfultable-delete")).click();
        Poller.waitUntilFalse((String)"Nav link row should be removed", (TimedQuery)row.timed().isPresent());
    }

    public List<List<String>> getNavLinks() {
        List<PageElement> tdRows = this.getTableRows();
        ArrayList<List<String>> rows = new ArrayList<List<String>>(tdRows.size());
        for (PageElement td : tdRows) {
            ArrayList<String> row = new ArrayList<String>(2);
            this.scrollTable(TableSide.LEFT);
            row.add(td.find(By.className((String)"custom-apps-restfultable-displayname")).getText());
            row.add(td.find(By.cssSelector((String)"td:nth-child(3)")).getText());
            rows.add(row);
        }
        return rows;
    }

    public boolean hasNavLink(String displayName) {
        return this.findNavLink(displayName) != -1;
    }

    private int findNavLink(String displayName) {
        List<List<String>> navLinks = this.getNavLinks();
        for (int i = 0; i < navLinks.size(); ++i) {
            if (!navLinks.get(i).get(0).equals(displayName)) continue;
            return i;
        }
        return -1;
    }

    private List<PageElement> getTableRows() {
        return this.tableElement.findAll(By.className((String)"aui-restfultable-readonly"));
    }

    private void scrollTable(TableSide side) {
        JavascriptExecutor executor = (JavascriptExecutor)WebDriverUtil.as((WebDriver)this.driver, JavascriptExecutor.class);
        executor.executeScript("document.querySelector('.aui-page-panel-content > form.aui').scrollLeft = " + (switch (side.ordinal()) {
            case 0 -> 0;
            default -> 1000;
        }) + ";", new Object[0]);
    }

    private static enum TableSide {
        LEFT,
        RIGHT;

    }
}

