/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.pageobjects.page.PullRequestOverviewPage;
import com.atlassian.bitbucket.pageobjects.page.next.PullRequestCreatePage;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.BranchSelect;
import com.atlassian.webdriver.bitbucket.element.PullRequestStateSelect;
import com.atlassian.webdriver.bitbucket.element.PullRequestTable;
import com.atlassian.webdriver.bitbucket.element.UserSelect;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import org.openqa.selenium.By;

public class PullRequestListPage
extends BaseRepositoryPage {
    private final Map<String, String> filters;
    private UserSelect authorFilter;
    private UserSelect reviewerFilter;
    @ElementBy(id="list-create-pr-button")
    private PageElement createActionButton;
    @ElementBy(id="pull-requests-content")
    private PageElement pullRequestTable;
    @ElementBy(id="pr-search-query-filter")
    private PageElement titleDescriptionFilter;
    private PullRequestStateSelect stateFilter;
    private BranchSelect targetBranchFilter;

    public PullRequestListPage(String projectKey, String slug) {
        this(projectKey, slug, Maps.newHashMap());
    }

    public PullRequestListPage(String projectKey, String slug, Map<String, String> filters) {
        super(projectKey, slug);
        this.filters = ImmutableMap.copyOf(filters);
    }

    @Init
    private void bindComponents() {
        this.authorFilter = (UserSelect)this.pageBinder.bind(UserSelect.class, new Object[]{this.elementFinder.find(By.id((String)"s2id_pr-author-filter"))});
        this.stateFilter = (PullRequestStateSelect)this.pageBinder.bind(PullRequestStateSelect.class, new Object[]{this.elementFinder.find(By.id((String)"s2id_pr-state-filter"))});
        this.targetBranchFilter = (BranchSelect)this.pageBinder.bind(BranchSelect.class, new Object[]{this.elementFinder.find(By.id((String)"s2id_pr-target-branch-filter"))});
        this.reviewerFilter = (UserSelect)this.pageBinder.bind(UserSelect.class, new Object[]{this.elementFinder.find(By.id((String)"s2id_pr-reviewer-filter"))});
    }

    public PullRequestCreatePage clickCreateActionButton() {
        this.createActionButton.click();
        return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.projectKey, this.slug});
    }

    public PullRequestCreatePage toggleShowDrafts() {
        PageElement showDraftsFilter = this.elementFinder.find(By.cssSelector((String)"label[for='pr-draft-filter']"));
        showDraftsFilter.click();
        Poller.waitUntilFalse((TimedQuery)this.getTableSpinner().timed().isPresent());
        return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.projectKey, this.slug});
    }

    public void filterByAuthor(String author) {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> ((UserSelect)((UserSelect)this.authorFilter.openOptions()).type(author)).selectOption(author));
    }

    public void filterByReviewer(String reviewer) {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> ((UserSelect)((UserSelect)this.reviewerFilter.openOptions()).type(reviewer)).selectOption(reviewer));
    }

    public void filterByState(PullRequestState state) {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> ((PullRequestStateSelect)this.stateFilter.openOptions()).selectOption(state.name()));
    }

    public void filterByTargetBranch(String branch) {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> ((BranchSelect)((BranchSelect)this.targetBranchFilter.openOptions()).type(branch)).selectOption(branch));
    }

    public void filterByTitleAndDescription(String filterText) {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> this.titleDescriptionFilter.clear().type(new CharSequence[]{filterText}));
    }

    public PullRequestTable getPullRequestTable() {
        Poller.waitUntilFalse((TimedQuery)this.getTableSpinner().timed().isPresent());
        return (PullRequestTable)this.pageBinder.bind(PullRequestTable.class, new Object[]{this.pullRequestTable});
    }

    public PullRequestTable.Entry getPullRequestTableEntry(long pullRequestId) {
        try {
            return (PullRequestTable.Entry)Iterables.find(this.getPullRequestTable().getRows(), row -> pullRequestId == row.getId());
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No pull request with ID " + pullRequestId + " in the list");
        }
    }

    public PageElement getTableSpinner() {
        return this.pullRequestTable.find(By.cssSelector((String)"aui-spinner"));
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/pull-requests" + this.getQueryString();
    }

    public boolean isBuildStatusColumnVisible() {
        PageElement buildColumn = this.elementFinder.find(By.cssSelector((String)"th.build-status-pr-list-col"));
        return (Boolean)buildColumn.timed().isPresent().byDefaultTimeout() != false && (Boolean)buildColumn.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isCreateActionButtonVisible() {
        return (Boolean)this.createActionButton.timed().isPresent().byDefaultTimeout() != false && (Boolean)this.createActionButton.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isGettingStartedMessageVisible() {
        PageElement gettingStartedMessage = this.elementFinder.find(By.cssSelector((String)".pull-request-intro"));
        return (Boolean)gettingStartedMessage.timed().isPresent().byDefaultTimeout() != false && (Boolean)gettingStartedMessage.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isNoResultsMessageVisible() {
        PageElement noMoreMessage = this.elementFinder.find(By.cssSelector((String)".pull-request-list .empty-banner-content"));
        return (Boolean)noMoreMessage.timed().isPresent().byDefaultTimeout() != false && (Boolean)noMoreMessage.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isNoMoreResultsMessageVisible() {
        PageElement noMoreResultsMessage = this.elementFinder.find(By.className((String)"paged-table-message"));
        return (Boolean)noMoreResultsMessage.timed().isPresent().byDefaultTimeout() != false && (Boolean)noMoreResultsMessage.timed().isVisible().byDefaultTimeout() != false;
    }

    public PullRequestOverviewPage navigateToPullRequest(long pullRequestId) {
        PageElement pullRequestLink = this.elementFinder.find(By.cssSelector((String)(".summary[data-pull-request-id=\"" + pullRequestId + "\"] .pull-request-title")));
        pullRequestLink.click();
        return (PullRequestOverviewPage)this.pageBinder.bind(PullRequestOverviewPage.class, new Object[]{this.projectKey, this.slug, pullRequestId});
    }

    public TimedCondition isModalVisible(String text) {
        return this.elementFinder.find(By.xpath((String)("//*[.=('" + text + "')]"))).timed().isVisible();
    }

    private String getQueryString() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> entry : this.filters.entrySet()) {
            buffer.append(buffer.length() == 0 ? "?" : "&").append(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return buffer.toString();
    }
}

