/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.requiredbuilds;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.refmatcher.RefMatcherSelector;
import com.atlassian.webdriver.bitbucket.element.refmatcher.RepositoryRefMatcherSelector;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class RequiredBuildsForm
extends AbstractElementPageObject {
    private final PageElement buildKeysSelector = this.find(By.className((String)"build-keys-selector"));
    private final PageElement cancelButton;
    private final PageElement destinationRefSelector = this.find(By.cssSelector((String)"[data-testid='destination-ref-selector']"));
    private final PageElement exemptionRefSelector = this.find(By.cssSelector((String)"[data-testid='exemption-ref-selector']"));
    private final PageElement saveButton = this.find(By.cssSelector((String)"[data-testid='save-button']"));

    public RequiredBuildsForm(@Nonnull PageElement container) {
        super(container);
        this.cancelButton = this.find(By.cssSelector((String)"[data-testid='cancel-button']"));
    }

    public void clickCancel() {
        this.cancelButton.click();
    }

    public void clickSave() {
        this.saveButton.click();
    }

    public List<String> getBuildKeys() {
        return this.buildKeysSelector.findAll(By.className((String)"build-parent-keys-selector__multi-value")).stream().map(multiVal -> multiVal.find(By.className((String)"build-parent-keys-selector__multi-value__label")).getText()).collect(Collectors.toList());
    }

    public RefMatcherSelector getDestinationRefSelector() {
        return (RefMatcherSelector)this.pageBinder.bind(RepositoryRefMatcherSelector.class, new Object[]{this.destinationRefSelector});
    }

    public RefMatcherSelector getExemptionRefSelector() {
        return (RefMatcherSelector)this.pageBinder.bind(RepositoryRefMatcherSelector.class, new Object[]{this.exemptionRefSelector});
    }

    public void selectBuildKey(String search, String buildKey) {
        this.buildKeysSelector.click();
        PageElement input = this.buildKeysSelector.find(By.tagName((String)"input"));
        input.type(new CharSequence[]{search});
        Poller.waitUntilFalse((TimedQuery)this.buildKeysSelector.find(By.className((String)"build-parent-keys-selector__menu-notice--loading")).timed().isPresent());
        String dataTestValue = String.format("[data-test-value='%s']", buildKey);
        this.buildKeysSelector.find(By.cssSelector((String)dataTestValue)).click();
    }

    public void selectBuildKey(String buildKey) {
        this.selectBuildKey(buildKey, buildKey);
    }
}

