/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.dashboard;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class DashboardRepositories
extends AbstractElementPageObject {
    public DashboardRepositories(@Nonnull PageElement container) {
        super(container);
    }

    public List<RepositoryRow> getRepositories() {
        return this.container.findAll(By.cssSelector((String)".dashboard-repositories-list > li")).stream().map(ElementUtils.bind(this.pageBinder, RepositoryRow.class, new Object[0])).collect(Collectors.toList());
    }

    public PageElement getSearchField() {
        return this.container.find(By.cssSelector((String)".search input"));
    }

    public SearchResults getSearchResults() {
        return (SearchResults)this.pageBinder.bind(SearchResults.class, new Object[]{this.container.find(By.className((String)"search-results"))});
    }

    public PageElement getEmptyMessage() {
        return this.container.find(By.cssSelector((String)".empty .message"));
    }

    public TimedElement getMatches() {
        return this.container.find(By.className((String)"search-matches")).timed();
    }

    public static class RepositoryRow
    extends AbstractElementPageObject {
        public RepositoryRow(@Nonnull PageElement container) {
            super(container);
        }

        public String getRepositoryName() {
            return this.container.find(By.className((String)"repository-name")).getText();
        }
    }

    public static class SearchResults
    extends AbstractElementPageObject {
        public SearchResults(@Nonnull PageElement container) {
            super(container);
        }

        public void clickShowMore() {
            final int initialCount = this.getRepositories().size();
            PageElement showMoreButton = this.container.find(By.className((String)"show-more"));
            ElementUtils.scrollIntoView(showMoreButton);
            showMoreButton.click();
            Poller.waitUntilTrue((String)"The number of visible repositories has increased", (TimedQuery)new AbstractTimedCondition(5000L, 100L){

                protected Boolean currentValue() {
                    return this.getRepositories().size() > initialCount;
                }
            });
        }

        public TimedElement getNoResultsMessage() {
            return this.container.find(By.cssSelector((String)".no-results .message")).timed();
        }

        public List<RepositoryRow> getRepositories() {
            return this.container.findAll(By.cssSelector((String)".dashboard-repositories-list > li")).stream().map(ElementUtils.bind(this.pageBinder, RepositoryRow.class, new Object[0])).collect(Collectors.toList());
        }
    }
}

