/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.Participant;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.By;

public class PullRequestTable
extends AbstractElementPageObject {
    public PullRequestTable(PageElement pageElement) {
        super(pageElement);
    }

    public Iterable<String> getColumnNames() {
        return Iterables.transform(this.findAll(By.tagName((String)"th")), PageElement::getText);
    }

    public String getCurrentTimestamp() {
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isVisible());
        return this.container.getAttribute("data-last-updated");
    }

    public List<Entry> getRows() {
        Poller.waitUntilFalse((TimedQuery)this.container.find(By.cssSelector((String)"aui-spinner")).timed().isPresent());
        return Lists.transform((List)this.container.findAll(Locators.tableRow(), TimeoutType.PAGE_LOAD), ElementUtils.bind(this.pageBinder, Entry.class, new Object[0])::apply);
    }

    public void loadNextPage() {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> {
            ElementUtils.scrollDocument(this.container);
            Poller.waitUntilFalse((TimedQuery)this.container.find(By.cssSelector((String)"aui-spinner")).timed().isPresent());
        });
    }

    public void waitUntilTableIsUpdated(String currentTimestamp) {
        Poller.waitUntilFalse((TimedQuery)this.container.timed().hasAttribute("data-last-updated", currentTimestamp));
    }

    public static class Entry
    extends AbstractElementPageObject {
        public Entry(PageElement pageElement) {
            super(pageElement);
        }

        public String getAuthorName() {
            return this.getAuthorElement().getText();
        }

        public String getAuthorUsername() {
            return this.getAuthorElement().find(By.cssSelector((String)"span.user-avatar")).getAttribute("data-username");
        }

        public BuildStatusIcon getBuildStatusIcon() {
            PageElement icon = this.container.find(By.cssSelector((String)"td.build-status-pr-list-col-value [data-testid='build-summary-icon-link']"));
            Poller.waitUntilTrue((TimedQuery)icon.timed().isVisible());
            return (BuildStatusIcon)this.pageBinder.bind(BuildStatusIcon.class, new Object[]{icon});
        }

        public long getId() {
            String linkValue = this.find(By.cssSelector((String)"td.summary > div.title-and-target-branch > a.pull-request-title")).getAttribute("href");
            return Long.parseLong(linkValue.split("/")[linkValue.split("/").length - 2]);
        }

        public int getOpenTaskCount() {
            PageElement count = this.container.find(By.cssSelector((String)"td.count-column-value.tasks > span > span.count"), TimeoutType.DEFAULT);
            return (Boolean)count.timed().isPresent().byDefaultTimeout() != false ? Integer.parseInt(count.getText()) : 0;
        }

        public PageElement getPullRequestTableColumnAfterButtonCSE() {
            return this.container.find(By.className((String)"pull-request-table-column-after-button-extension"));
        }

        public PageElement getPullRequestTableColumnAfterLinkCSE() {
            return this.container.find(By.className((String)"pull-request-table-column-after-link-extension"));
        }

        public PageElement getPullRequestTableColumnAfterModalCSE() {
            return this.container.find(By.className((String)"pull-request-table-column-after-modal-extension"));
        }

        public PageElement getPullRequestTableColumnBeforeButtonCSE() {
            return this.container.find(By.className((String)"pull-request-table-column-before-button-extension"));
        }

        public PageElement getPullRequestTableColumnBeforeLinkCSE() {
            return this.container.find(By.className((String)"pull-request-table-column-before-link-extension"));
        }

        public PageElement getPullRequestTableColumnBeforeModalCSE() {
            return this.container.find(By.className((String)"pull-request-table-column-before-modal-extension"));
        }

        public List<Participant> getReviewers() {
            return this.container.findAll(By.cssSelector((String)".reviewer-avatar-list > .user-avatar"), Participant.class);
        }

        public String getTargetBranch() {
            return this.find(By.cssSelector((String)"td.summary > div.title-and-target-branch > span.pull-request-target-branch")).getText();
        }

        public String getTitle() {
            return this.find(By.cssSelector((String)"td.summary > div.title-and-target-branch > a.pull-request-title")).getText();
        }

        public boolean hasBuildStatus() {
            PageElement icon = this.container.find(By.cssSelector((String)"td.build-status-pr-list-col-value [data-testid='build-summary-icon-link']"));
            return (Boolean)icon.timed().isPresent().byDefaultTimeout();
        }

        private PageElement getAuthorElement() {
            return this.find(By.cssSelector((String)"td.summary > div.author-and-timestamp > div.avatar-with-name"));
        }
    }
}

