/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.pageobjects.element.PullRequestList;
import com.atlassian.bitbucket.pageobjects.page.next.ComparePage;
import com.atlassian.bitbucket.pageobjects.page.next.PullRequestCreatePage;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.BranchDeleteDialog;
import com.atlassian.webdriver.bitbucket.element.Dialog;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.admin.settings.ref.restriction.RepoBranchPermissionsPage;
import com.atlassian.webdriver.bitbucket.page.branches.BranchListPage;
import com.atlassian.webdriver.bitbucket.util.DateUtils;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.time.Instant;
import java.util.List;
import org.openqa.selenium.By;

public class BranchList {
    private final PageElement filterElement;
    private final BranchListPage parent;
    private final PageElement tableElement;
    private Long lastUpdated;
    @Inject
    private PageElementFinder elementFinder;
    @Inject
    private PageBinder pageBinder;

    public BranchList(BranchListPage parent, PageElement tableElement, PageElement filterElement, Long lastUpdated) {
        this.parent = parent;
        this.tableElement = tableElement;
        this.filterElement = filterElement;
        this.lastUpdated = lastUpdated;
    }

    @WaitUntil
    public void ensureLoaded() {
        ElementUtils.waitUntilUpdated(this.tableElement, this.lastUpdated);
        this.lastUpdated = ElementUtils.getLastUpdated(this.tableElement);
    }

    public BranchList filter(String filterText) {
        ElementUtils.waitUntilUpdated(this.tableElement, () -> this.filterBranchName(filterText));
        return this;
    }

    public void filterBranchName(String filterText) {
        this.filterElement.type(new CharSequence[]{filterText});
    }

    public BranchListEntry getBaseBranchRow() {
        return this.getRowWithLozenge("BASE BRANCH");
    }

    public List<String> getColumnNames() {
        List headers = this.tableElement.findAll(By.tagName((String)"th"));
        return Lists.transform((List)headers, PageElement::getText);
    }

    public BranchListEntry getDefaultBranchRow() {
        return this.getRowWithLozenge("DEFAULT BRANCH");
    }

    public BranchListEntry getFocusedRow() {
        PageElement focusedElement = this.tableElement.find(By.cssSelector((String)"tbody > tr.focused"));
        Poller.waitUntilTrue((TimedQuery)focusedElement.timed().isVisible());
        return (BranchListEntry)this.pageBinder.bind(BranchListEntry.class, new Object[]{this, focusedElement});
    }

    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    public BranchListEntry getRow(String name) {
        return MoreStreams.streamIterable(this.rowIterator()).filter((? super T input) -> input.getName().equals(name)).findFirst().orElse(null);
    }

    public BranchListEntry getRowOrFail(String name) {
        BranchListEntry entry = this.getRow(name);
        if (entry == null) {
            throw new RuntimeException(String.format("Unable to find branch '%s'.", name));
        }
        return entry;
    }

    public List<BranchListEntry> getRows() {
        return ImmutableList.copyOf(this.rowIterator());
    }

    public PageElement getTableElement() {
        return this.tableElement;
    }

    private PageElement getMessageElement() {
        return this.elementFinder.find(By.cssSelector((String)"[class$=\"-EmptyStateHeader\"]"));
    }

    private BranchListEntry getRowWithLozenge(String lozenge) {
        for (BranchListEntry row : this.getRows()) {
            if (!row.getColumn("branch-name-column").getText().contains(lozenge)) continue;
            return row;
        }
        return null;
    }

    public boolean isBuildStatusColumnVisible() {
        return this.tableElement.find(By.id((String)"build-status-branch-list-column")).isPresent();
    }

    public boolean isFilterFocused() {
        return (Boolean)this.filterElement.javascript().execute("return jQuery(arguments[0]).is(':focus')", new Object[0]);
    }

    public BranchList loadNextPage() {
        PageElement messageElement = this.getMessageElement();
        if (!messageElement.isPresent()) {
            ElementUtils.scrollDocumentAndWait(this.tableElement);
        }
        return this;
    }

    private Iterable<BranchListEntry> rowIterator() {
        return Iterables.transform((Iterable)this.tableElement.findAll(By.cssSelector((String)"tbody > tr")), element -> (BranchListEntry)this.pageBinder.bind(BranchListEntry.class, new Object[]{this, element}));
    }

    public static class BranchListEntry {
        private final PageElement element;
        private final BranchList parent;

        public BranchListEntry(BranchList parent, PageElement element) {
            this.parent = parent;
            this.element = element;
        }

        public ComparePage click() {
            return this.click(ComparePage.class, new Object[]{this.parent.parent.getProjectKey(), this.parent.parent.getSlug(), ComparePage.Tab.COMMITS});
        }

        public void clickActionByTestId(String testId) {
            this.getActionMenu().find(By.cssSelector((String)("[data-testid=\"" + testId + "\"]"))).click();
        }

        public PullRequestCreatePage clickCreatePullRequest() {
            this.clickActionByTestId("com.atlassian.bitbucket.server.bitbucket-frontend:extension__branch-list__create-pull-request-action__create-pull-request-action-extension__ts");
            return (PullRequestCreatePage)this.parent.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.parent.parent.getProjectKey(), this.parent.parent.getSlug()});
        }

        public RepoBranchPermissionsPage clickEditBranchPermissions() {
            this.clickActionByTestId("com.atlassian.bitbucket.server.bitbucket-frontend:extension__branch-list__edit-branch-permissions-action__edit-branch-permissions-action-extension__ts");
            return (RepoBranchPermissionsPage)this.parent.pageBinder.bind(RepoBranchPermissionsPage.class, new Object[]{this.parent.parent.getProjectKey(), this.parent.parent.getSlug()});
        }

        public PullRequestListDialog clickPullRequestLink() {
            this.getColumn("pull-requests-column").find(By.cssSelector((String)"[data-testid=\"pull-request-list-trigger\"]")).click();
            return (PullRequestListDialog)((Object)this.parent.pageBinder.bind(PullRequestListDialog.class, new Object[]{By.cssSelector((String)"[data-testid=\"pull-request-list-dialog\"]"), TimeoutType.DIALOG_LOAD}));
        }

        public PageElement getActionMenu() {
            this.triggerActionMenu();
            PageElement menu = this.parent.elementFinder.find(By.className((String)"branch-list-action-dropdown"));
            Poller.waitUntilTrue((TimedQuery)menu.timed().isVisible());
            return menu;
        }

        public String getAheadBehindToolTip() {
            PageElement graphElement = this.getColumn("ahead-behind-column").find(By.className((String)"ahead-behind-graph"));
            if (!graphElement.isPresent()) {
                graphElement = this.getColumn("ahead-behind-column");
            }
            return this.getTitle(graphElement);
        }

        public Integer getAheadCount() {
            return this.getCommitCount("ahead");
        }

        public Integer getBehindCount() {
            return this.getCommitCount("behind");
        }

        public BuildStatusIcon getBuildStatusIcon() {
            PageElement icon = this.getColumn("build-status-branch-list-column").find(By.cssSelector((String)"[data-testid=\"build-summary-icon-link\"]"));
            return (BuildStatusIcon)this.parent.pageBinder.bind(BuildStatusIcon.class, new Object[]{icon});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDownloadLinkHref() {
            PageElement actionMenu = this.getActionMenu();
            PageElement downloadAction = actionMenu.find(By.cssSelector((String)"[data-testid=\"com.atlassian.bitbucket.server.bitbucket-frontend:extension__branch-list__download-branch-action__download-branch-action-extension__ts\"]"));
            try {
                String string = downloadAction.isPresent() ? downloadAction.getAttribute("href") : null;
                return string;
            }
            finally {
                if (actionMenu.isVisible()) {
                    this.triggerActionMenu();
                }
            }
        }

        public PageElement getElement() {
            return this.element;
        }

        public PageElement getElementByClassName(String className) {
            return this.element.find(By.className((String)className));
        }

        public String getId() {
            return this.element.getAttribute("data-id");
        }

        public String getJiraIssueKeys() {
            return ((PageElement)this.getJiraIssuesColumn().findAll(By.tagName((String)"span")).getFirst()).getAttribute("data-issue-keys");
        }

        public PageElement getJiraIssuesColumn() {
            return this.getColumn("branch-list-jira-issues-column");
        }

        public String getName() {
            return this.getBranchLink().getText();
        }

        public String getPullRequestLinkTooltip() {
            PageElement status = this.getColumn("pull-requests-column").find(By.cssSelector((String)".branch-list-pull-requests"));
            if (status.isPresent()) {
                return status.getAttribute("data-tooltip");
            }
            return null;
        }

        public String getPullRequestStatus() {
            PageElement status = this.getColumn("pull-requests-column").find(By.cssSelector((String)"[data-testid=\"pull-request-list-trigger\"]"));
            if (status.isPresent()) {
                return status.getText();
            }
            return null;
        }

        public List<String> getRowActionMenuTestIds() {
            PageElement menu = this.getActionMenu();
            return Lists.newArrayList((Iterable)Lists.transform((List)menu.findAll(By.cssSelector((String)"[role=\"menuitem\"]")), input -> {
                String attribute = input.getAttribute("data-testid");
                return attribute;
            }));
        }

        public Instant getUpdated() {
            PageElement timeElement = this.getColumn("last-updated-column").find(By.tagName((String)"time"));
            return timeElement.isPresent() ? DateUtils.parseServerTimestamp(timeElement.getAttribute("datetime")).toInstant() : null;
        }

        public boolean hasBuildStatus() {
            PageElement cell = this.getColumn("build-status-branch-list-column");
            return cell.isPresent() && cell.find(By.cssSelector((String)"[data-testid=\"build-summary-icon-link\"]")).isPresent();
        }

        public boolean hasPullRequestColumn() {
            PageElement cell = this.getColumn("pull-requests-column");
            return cell.isPresent() && cell.find(By.cssSelector((String)"[data-testid=\"pull-request-list-trigger\"]")).isPresent();
        }

        public boolean isAheadBehindNotAvailable() {
            return this.getColumn("ahead-behind-column").getText().contains("Not available");
        }

        public BranchDeleteDialog openDeleteBranchDialog() {
            this.clickActionByTestId("com.atlassian.bitbucket.server.bitbucket-frontend:extension__branch-list__delete-branch-action__delete-branch-action-extension__js");
            PageElement dialogContainer = this.parent.elementFinder.find(By.cssSelector((String)"[data-testid=\"client-extensions-modal\"]"));
            return (BranchDeleteDialog)this.parent.pageBinder.bind(BranchDeleteDialog.class, new Object[]{dialogContainer});
        }

        private <T extends BaseRepositoryPage> T click(Class<T> comparePageClass, Object ... args) {
            this.getBranchLink().click();
            return (T)((BaseRepositoryPage)this.parent.pageBinder.bind(comparePageClass, args));
        }

        private PageElement getBranchLink() {
            return this.getColumn("branch-name-column").find(By.tagName((String)"a"));
        }

        private PageElement getColumn(String name) {
            PageElement pageElement = this.element.find(By.className((String)name));
            Poller.waitUntilTrue((String)("Column " + name + " should be present"), (TimedQuery)pageElement.timed().isPresent());
            return pageElement;
        }

        private Integer getCommitCount(String type) {
            PageElement countElement = this.getColumn("ahead-behind-column").find(By.cssSelector((String)("." + type + "-graph .count")));
            if (countElement.isPresent()) {
                String count = countElement.getText().trim();
                return count.isEmpty() ? 0 : Integer.parseInt(count);
            }
            return null;
        }

        private String getTitle(PageElement graphElement) {
            String titleAttribute = graphElement.getAttribute("title");
            return titleAttribute == null || titleAttribute.isEmpty() ? graphElement.getAttribute("original-title") : titleAttribute;
        }

        private void triggerActionMenu() {
            this.getColumn("branch-actions-column").find(By.tagName((String)"button")).click();
        }
    }

    public static class PullRequestListDialog
    extends Dialog {
        @Inject
        private PageElementFinder elementFinder;

        public PullRequestListDialog(By locator) {
            super(locator);
        }

        public PullRequestListDialog(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public PullRequestListDialog(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public PullRequestList getPullRequestList() {
            return (PullRequestList)this.pageBinder.bind(PullRequestList.class, new Object[]{this.elementFinder.find(By.className((String)"pull-requests-list-table"))});
        }

        @Override
        public TimedCondition isOpen() {
            return this.find(By.className((String)"pull-requests-list-table"), TimeoutType.DIALOG_LOAD).timed().isVisible();
        }
    }
}

