/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class BranchDeleteDialog
extends AbstractElementPageObject {
    private static final String NOT_MERGED_ID = "delete-branch-not-merged-warning";
    private static final Pattern NOT_MERGED_MESSAGE = Pattern.compile("branch has (\\d+) commits?.*not on (.+)$");

    public BranchDeleteDialog(PageElement container) {
        super(container);
    }

    public void clickCancel() {
        this.container.find(By.cssSelector((String)"[data-testid=\"delete-branch-modal-cancel-button\"]")).click();
    }

    public void clickConfirm() {
        this.container.find(By.cssSelector((String)"[data-testid=\"delete-branch-modal-confirm-button\"]")).click();
    }

    public String getNotMergedBranch() {
        return this.getNotMergedMatcher().group(2);
    }

    public long getNotMergedCommitCount() {
        return Long.parseLong(this.getNotMergedMatcher().group(1));
    }

    public boolean hasNotMergedWarning() {
        return this.findNotMerged() != null;
    }

    private PageElement findNotMerged() {
        PageElement element = this.container.find(By.id((String)NOT_MERGED_ID));
        if (element.isPresent()) {
            return element;
        }
        return null;
    }

    private PageElement findNotMergedOrFail() {
        PageElement notMergedElement = this.findNotMerged();
        if (notMergedElement == null) {
            throw new RuntimeException("Dialog does not have not merged message.");
        }
        return notMergedElement;
    }

    private Matcher getNotMergedMatcher() {
        Matcher matcher = NOT_MERGED_MESSAGE.matcher(this.findNotMergedOrFail().getText());
        if (matcher.find()) {
            return matcher;
        }
        throw new RuntimeException("Unable to parse message in delete dialog.");
    }
}

