/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket;

import com.atlassian.bitbucket.test.BuildStatusTestHelper;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import org.openqa.selenium.By;

public class BuildStatusIcon
extends AbstractElementPageObject {
    public BuildStatusIcon(@Nonnull PageElement container) {
        super(container);
    }

    public BuildStatusTestHelper.State getStatus() {
        PageElement statusIcon = this.find(By.className((String)"build-status-icon"));
        if (!statusIcon.isPresent()) {
            statusIcon = this.container;
        }
        if (statusIcon.hasClass("successful-build-icon") || statusIcon.hasClass("build-successful-icon")) {
            return BuildStatusTestHelper.State.SUCCESSFUL;
        }
        if (statusIcon.hasClass("failed-build-icon") || statusIcon.hasClass("build-failed-icon")) {
            return BuildStatusTestHelper.State.FAILED;
        }
        if (statusIcon.hasClass("inprogress-build-icon") || statusIcon.hasClass("build-inprogress-icon") || statusIcon.hasClass("build-in-progress-icon")) {
            return BuildStatusTestHelper.State.INPROGRESS;
        }
        if (statusIcon.hasClass("unknown-build-icon") || statusIcon.hasClass("build-unknown-icon")) {
            return BuildStatusTestHelper.State.UNKNOWN;
        }
        if (statusIcon.hasClass("cancelled-build-icon") || statusIcon.hasClass("build-cancelled-icon")) {
            return BuildStatusTestHelper.State.CANCELLED;
        }
        return null;
    }

    public String getLink() {
        return this.container.getAttribute("href");
    }
}

