/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.permissions;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.openqa.selenium.By;

public class RemovePermissionDialog
extends AbstractElementPageObject {
    @Inject
    private PageElementFinder elementFinder;

    public RemovePermissionDialog(@Nonnull PageElement container) {
        super(container);
    }

    public void clickCancel() {
        this.container.find(By.id((String)"cancel-remove-permission-button")).click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isPresent());
    }

    public void clickConfirm() {
        this.container.find(By.id((String)"confirm-remove-permission-button")).click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isPresent());
    }

    public TimedQuery<Boolean> clickRemoveAndAssertError() {
        this.container.find(By.id((String)"confirm-remove-permission-button")).click();
        PageElement errorDialog = this.elementFinder.find(By.cssSelector((String)"section[id='ajax-error']"));
        return errorDialog.timed().isVisible();
    }

    public String getMessage() {
        return this.container.find(By.className((String)"remove-permissions")).getText();
    }
}

