/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.permissions;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class PermissionSelector
extends AbstractElementPageObject {
    @Inject
    private PageElementFinder elementFinder;

    public PermissionSelector(@Nonnull PageElement container) {
        super(container);
    }

    public TimedQuery<List<String>> getPermissions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ((List)this.getDropdownList().byDefaultTimeout()).stream().map(PageElement::getText).collect(Collectors.toList()));
    }

    public TimedQuery<String> getSelectedPermission() {
        return this.dropdownSelector().timed().getText();
    }

    public void selectPermission(String permission) {
        this.dropdownSelector().click();
        ((List)Poller.waitUntil(this.getDropdownList(), (Matcher)CoreMatchers.hasItem((Matcher)PageElementMatchers.withText((String)permission)))).stream().filter(p -> permission.equals(p.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("%s not found in the permissionPermissionSelector selector drop-down", permission))).click();
    }

    private PageElement dropdownSelector() {
        return this.container.find(By.className((String)"permission-selector"));
    }

    private TimedQuery<List<PageElement>> getDropdownList() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.elementFinder.findAll(By.cssSelector((String)".permission-selector-option > h4")));
    }
}

