/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.permissions;

import com.atlassian.bitbucket.pageobjects.element.permissions.AddOrEditPermissionDialog;
import com.atlassian.bitbucket.pageobjects.element.permissions.RemovePermissionDialog;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.google.common.base.MoreObjects;
import jakarta.inject.Inject;
import org.openqa.selenium.By;

public class PermissionListItem
extends AbstractElementPageObject {
    private static final String PERMISSION_LEVEL = "permissionLevel";
    private static final String PERMISSION_NAME = "permissionName";
    private static final String USER_OR_GROUP_NAME = "userOrGroupName";
    @Inject
    private PageElementFinder elementFinder;

    public PermissionListItem(PageElement container) {
        super(container);
    }

    public AddOrEditPermissionDialog clickEdit() {
        this.elementFinder.find(By.cssSelector((String)"[data-testid='edit-permission']")).click();
        PageElement editPermissionModal = this.container.find(By.xpath((String)"//*[@data-testid='permission-modal']"));
        Poller.waitUntilTrue((TimedQuery)editPermissionModal.timed().isVisible());
        return (AddOrEditPermissionDialog)this.pageBinder.bind(AddOrEditPermissionDialog.class, new Object[]{editPermissionModal});
    }

    public RemovePermissionDialog clickRemove() {
        this.elementFinder.find(By.cssSelector((String)"[data-testid='remove-permission']")).click();
        PageElement removePermissionModal = this.container.find(By.xpath((String)"//*[@data-testid='remove-permission-modal']"));
        Poller.waitUntilTrue((TimedQuery)removePermissionModal.timed().isVisible());
        return (RemovePermissionDialog)this.pageBinder.bind(RemovePermissionDialog.class, new Object[]{removePermissionModal});
    }

    public String getPermissionLevel() {
        return this.container.find(By.className((String)"permission-level")).getText();
    }

    public String getPermissionName() {
        return this.container.find(By.className((String)"permission-name")).getText();
    }

    public String getUserOrGroupName() {
        return this.container.find(By.className((String)"user-or-group-name")).getText();
    }

    public PermissionListItem openActionsMenu() {
        this.container.find(By.cssSelector((String)"button[data-testid='actions-menu-trigger']")).click();
        PageElement menuActions = this.elementFinder.find(By.className((String)"actions-menu-content"));
        Poller.waitUntilTrue((TimedQuery)menuActions.timed().isVisible());
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(PermissionListItem.class).omitNullValues().add(USER_OR_GROUP_NAME, (Object)this.getUserOrGroupName()).add(PERMISSION_LEVEL, (Object)this.getPermissionLevel()).add(PERMISSION_NAME, (Object)this.getPermissionName()).toString();
    }
}

