/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.comments;

import com.atlassian.bitbucket.pageobjects.element.CodeMirrorEditor;
import com.atlassian.bitbucket.pageobjects.element.comments.Comment;
import com.atlassian.bitbucket.pageobjects.element.tasks.Task;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.html5.LocalStorage;

public abstract class CommentForm
extends CodeMirrorEditor<CommentForm> {
    private final PageElement cancelButton = this.find(By.className((String)"comment-editor-cancel"));
    private final PageElement createTaskButton = this.find(By.cssSelector((String)"[data-testid='create-task-button']"));
    private final PageElement editorError = this.find(By.className((String)"editor-error"));
    private final PageElement insertSuggestionButton = this.find(By.cssSelector((String)"[data-testid='insert-suggestion-button']"));
    private final PageElement lineMarkers = this.find(By.cssSelector((String)"[data-testid='line-markers']"));
    private final PageElement pendingLozenge = this.find(By.cssSelector((String)"[data-testid='pending-lozenge']"));
    private final PageElement reviewModeCheckbox = this.find(By.cssSelector((String)"[data-testid='checkbox-review-mode--checkbox-label']"));
    private final PageElement saveCommentButton = this.find(By.cssSelector((String)"[data-testid='comment-editor-save-button']"));
    private final PageElement submitCommentButton = this.find(By.cssSelector((String)"[data-testid='comment-editor-submit-button']"));
    @Inject
    private LocalStorage localStorage;

    public CommentForm(@Nonnull PageElement container) {
        super(container);
    }

    public void cancel() {
        this.cancelButton.click();
    }

    public CommentForm clickInsertSuggestion() {
        this.insertSuggestionButton.click();
        return this;
    }

    public CommentForm clickReviewModeCheckbox() {
        this.reviewModeCheckbox.click();
        return this;
    }

    public PageElement getInsertSuggestionButton() {
        return this.insertSuggestionButton;
    }

    public String getLineMarkers() {
        return this.lineMarkers.getText();
    }

    public boolean hasEditorError() {
        return this.editorError.isPresent() && this.editorError.isVisible();
    }

    public TimedCondition hasPendingLozenge() {
        return this.pendingLozenge.timed().isVisible();
    }

    public TimedCondition isDraftStored(String draftText) {
        return Conditions.forSupplier((Timeouts)this.timeouts, () -> this.localStorage.keySet().stream().anyMatch(key -> this.localStorage.getItem(key).contains(draftText)));
    }

    public Comment save() {
        this.saveCommentButton.click();
        Poller.waitUntilFalse((TimedQuery)this.saveCommentButton.timed().hasAttribute("data-has-overlay", "true"));
        return (Comment)this.pageBinder.bind(Comment.class, new Object[]{this.container});
    }

    public Comment submitComment() {
        this.submitCommentButton.click();
        Poller.waitUntilFalse((TimedQuery)this.submitCommentButton.timed().hasAttribute("data-has-overlay", "true"));
        if (this.hasEditorError()) {
            return null;
        }
        return this.getNewComment();
    }

    public Task submitTask() {
        this.createTaskButton.click();
        Poller.waitUntilFalse((TimedQuery)this.createTaskButton.timed().hasAttribute("data-has-overlay", "true"));
        if (this.hasEditorError()) {
            return null;
        }
        return this.getNewComment().asTask();
    }

    protected abstract Comment getNewComment();
}

