/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.page.PullRequestIterativeDiffPage;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import jakarta.annotation.Nonnull;
import org.openqa.selenium.By;

public class PullRequestTabs
extends AbstractElementPageObject {
    public PullRequestTabs(@Nonnull PageElement container) {
        super(container);
    }

    public PageElement getBuildsTab() {
        return this.find(By.cssSelector((String)"[data-testid='tab-BUILDS']")).withTimeout(TimeoutType.PAGE_LOAD);
    }

    public PageElement getCommitsTab() {
        return this.find(By.cssSelector((String)"[data-testid='tab-COMMITS']")).withTimeout(TimeoutType.PAGE_LOAD);
    }

    public PageElement getDiffTab() {
        return this.find(By.cssSelector((String)"[data-testid='tab-DIFF']")).withTimeout(TimeoutType.PAGE_LOAD);
    }

    public PageElement getCSETab(String urlSlug) {
        String tabTestId = String.format("[data-testid='tab-%s']", urlSlug);
        return this.find(By.cssSelector((String)tabTestId)).withTimeout(TimeoutType.PAGE_LOAD);
    }

    public String getDiffTabUrl() {
        return ((LinkElement)((Object)this.pageBinder.bind(LinkElement.class, new Object[]{this.getDiffTab().find(By.tagName((String)"a"))}))).getUrl();
    }

    public PullRequestIterativeDiffPage navigateToDiff(String projectKey, String slug, long pullRequestId, String sinceCommit, String untilCommit) {
        this.getDiffTab().click().withTimeout(TimeoutType.PAGE_LOAD);
        return (PullRequestIterativeDiffPage)this.pageBinder.bind(PullRequestIterativeDiffPage.class, new Object[]{projectKey, slug, pullRequestId, sinceCommit, untilCommit});
    }

    public PageElement getOverviewTab() {
        return this.find(By.cssSelector((String)"[data-testid='tab-OVERVIEW']")).withTimeout(TimeoutType.PAGE_LOAD);
    }
}

