/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.FileTreeNode;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.openqa.selenium.By;

public class FileTree
extends AbstractElementPageObject {
    public FileTree(@Nonnull PageElement container) {
        super(container);
    }

    public List<FileTreeNode> getFileStructure() {
        List elements = this.container.findAll(By.cssSelector((String)".file, .directory"));
        ImmutableList.Builder fileTreeNodeBuilder = ImmutableList.builder();
        for (PageElement element : elements) {
            fileTreeNodeBuilder.add((Object)((FileTreeNode)this.pageBinder.bind(FileTreeNode.class, new Object[]{element})));
        }
        return fileTreeNodeBuilder.build();
    }

    public List<FileTreeNode> getFiles() {
        return (List)this.getFileStructure().stream().filter(FileTreeNode::isLeaf).collect(MoreCollectors.toImmutableList());
    }

    public List<FileTreeNode> getDirectories() {
        return (List)this.getFileStructure().stream().filter(node -> !node.isLeaf()).collect(MoreCollectors.toImmutableList());
    }

    public boolean hasNoResults() {
        return this.find(By.cssSelector((String)"[data-testid='filtering-no-results']")).isVisible();
    }

    public void viewAllFiles() {
        List<FileTreeNode> files = this.getFiles();
        for (FileTreeNode file : files) {
            file.clickFile();
        }
    }
}

