/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.CodeMirrorEditor;
import com.atlassian.bitbucket.pageobjects.element.UserMultiSelector;
import com.atlassian.bitbucket.pageobjects.element.contributing.ContributingGuidelinesDialog;
import com.atlassian.bitbucket.pageobjects.page.PullRequestOverviewPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class CreatePullRequestForm
extends AbstractElementPageObject {
    private final PageElement changeButton = this.find(By.className((String)"change-button"));
    private final PageElement codeOwnersErrorMessage = this.find(By.className((String)"code-owner-error-message"));
    private final PageElement createButton = this.find(By.className((String)"create-button"));
    private final PageElement createDraftButton = this.find(By.className((String)"create-draft-button"));
    private final PageElement editor = this.find(By.className((String)"editor"));
    private final PageElement formError = this.find(By.className((String)"form-error"));
    private final PageElement formExtension = this.find(By.className((String)"create-pull-request-form-extension"));
    private final PageElement repositoryGuidelines = this.find(By.className((String)"repository-guidelines"));
    private final PageElement reviewerSelector = this.find(By.className((String)"user-multi-select"));
    private final PageElement sourceRef = this.find(By.cssSelector((String)".branch-from-to .ref-lozenge:first-child"));
    private final String targetProjectKey;
    private final PageElement targetRef = this.find(By.cssSelector((String)".branch-from-to .ref-lozenge:last-child"));
    private final String targetRepoSlug;
    private final PageElement title = this.find(By.id((String)"pull-request-title"));
    private final PageElement titleError = this.find(By.cssSelector((String)"[data-testid='title-error']"));
    @Inject
    private WebDriver webDriver;

    public CreatePullRequestForm(@Nonnull PageElement container) {
        super(container);
        this.targetProjectKey = this.targetRef.getAttribute("data-project-key");
        this.targetRepoSlug = this.targetRef.getAttribute("data-repo-slug");
    }

    public CreatePullRequestForm addReviewer(String reviewer) {
        this.getReviewerSelector().addUser(reviewer);
        return this;
    }

    public void clickChange() {
        this.changeButton.click();
    }

    public PullRequestOverviewPage clickCreate() {
        return this.clickCreate(this.createButton);
    }

    public PullRequestOverviewPage clickCreateDraft() {
        return this.clickCreate(this.createDraftButton);
    }

    public String getDescription() {
        return this.getDescriptionEditor().getText();
    }

    public CreatePullRequestForm setDescription(String description) {
        this.getDescriptionEditor().setText(description);
        return this;
    }

    public String getCodeOwnersErrorMessageText() {
        return this.codeOwnersErrorMessage.getText();
    }

    public CodeMirrorEditor getDescriptionEditor() {
        return (CodeMirrorEditor)this.pageBinder.bind(CodeMirrorEditor.class, new Object[]{this.editor});
    }

    public String getErrorText() {
        return this.formError.getText();
    }

    public PageElement getFormExtension() {
        return this.formExtension;
    }

    public UserMultiSelector getReviewerSelector() {
        return (UserMultiSelector)this.pageBinder.bind(UserMultiSelector.class, new Object[]{this.reviewerSelector});
    }

    public List<String> getReviewerUsernames() {
        return (List)this.getReviewerSelector().getValues().stream().map(UserMultiSelector.Value::getName).collect(MoreCollectors.toImmutableList());
    }

    public String getSourceRef() {
        return this.sourceRef.getText();
    }

    public String getTargetRef() {
        return this.targetRef.getText();
    }

    public String getTitle() {
        return this.title.getValue();
    }

    public CreatePullRequestForm setTitle(String title) {
        this.title.clear();
        this.title.type(new CharSequence[]{title});
        return this;
    }

    public String getTitleError() {
        return this.titleError.getText();
    }

    public boolean hasCodeOwnersErrorMessage() {
        return this.codeOwnersErrorMessage.isPresent();
    }

    public boolean hasContributingGuidelines() {
        return this.repositoryGuidelines.isPresent();
    }

    public boolean hasError() {
        return this.formError.isPresent();
    }

    public boolean isCreateButtonEnabled() {
        return this.createButton.isEnabled();
    }

    public ContributingGuidelinesDialog openContributingGuidelinesDialog() {
        PageElement contributingGuidelinesLink = this.repositoryGuidelines.find(By.tagName((String)"button"));
        Poller.waitUntilTrue((TimedQuery)contributingGuidelinesLink.timed().isVisible());
        contributingGuidelinesLink.click();
        return (ContributingGuidelinesDialog)this.pageBinder.bind(ContributingGuidelinesDialog.class, new Object[0]);
    }

    public CreatePullRequestForm removeReviewer(String reviewer) {
        this.getReviewerSelector().removeUser(reviewer);
        return this;
    }

    private PullRequestOverviewPage clickCreate(PageElement createButton) {
        createButton.click();
        Poller.waitUntilFalse((TimedQuery)createButton.timed().hasAttribute("data-has-overlay", "true"));
        if (this.hasError()) {
            return null;
        }
        String pullRequestPageURL = this.webDriver.getCurrentUrl();
        String[] pathArray = pullRequestPageURL.split("/");
        long pullRequestId = Long.parseLong(pathArray[pathArray.length - 2]);
        return (PullRequestOverviewPage)this.pageBinder.bind(PullRequestOverviewPage.class, new Object[]{this.targetProjectKey, this.targetRepoSlug, pullRequestId});
    }
}

