/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.RenderedMarkup;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.openqa.selenium.By;

public class CodeMirrorEditor<T extends CodeMirrorEditor>
extends AbstractElementPageObject {
    private final PageElement attachmentUploadProgress = this.find(By.className((String)"attachment-upload-progress"));
    private final PageElement disablePreviewButton = this.find(By.cssSelector((String)"[data-testid='comment-disable-preview-button']"));
    private final PageElement editorPreview = this.find(By.className((String)"editor-preview"));
    private final PageElement emoticonAutoCompleteList = this.find(By.className((String)"editor-autocomplete"));
    private final PageElement enablePreviewButton = this.find(By.cssSelector((String)"[data-testid='comment-enable-preview-button']"));
    private final PageElement fileUploadInput = this.find(By.className((String)"file-upload-input"));
    private final PageElement textArea = this.find(By.className((String)"CodeMirror-code"));
    @Inject
    private PageElementFinder elementFinder;

    public CodeMirrorEditor(@Nonnull PageElement container) {
        super(container);
    }

    public T attach(String attachmentPath) {
        ElementUtils.uploadFile(this.fileUploadInput, attachmentPath);
        Poller.waitUntilFalse((TimedQuery)this.attachmentUploadProgress.timed().isPresent());
        return (T)this;
    }

    public T disablePreview() {
        this.disablePreviewButton.click();
        Poller.waitUntilFalse((TimedQuery)this.editorPreview.timed().isVisible());
        return (T)this;
    }

    public RenderedMarkup enablePreview() {
        this.enablePreviewButton.click();
        Poller.waitUntilTrue((TimedQuery)this.editorPreview.timed().isVisible());
        return (RenderedMarkup)this.pageBinder.bind(RenderedMarkup.class, new Object[]{this.container});
    }

    public String getAttachmentUrl() {
        return this.find(By.className((String)"cm-url")).getText();
    }

    public TimedCondition getEmoticonAutoCompleteList() {
        return this.emoticonAutoCompleteList.timed().isVisible();
    }

    public String getText() {
        PageElement codeMirror = this.elementFinder.find(By.className((String)"CodeMirror"));
        return (String)codeMirror.javascript().execute("cm = arguments[0].CodeMirror; return cm.getValue();", new Object[0]);
    }

    public boolean isDisabled() {
        return this.container.hasClass("disabled");
    }

    public void selectText(int start, int end, int line) {
        this.elementFinder.find(By.className((String)"CodeMirror")).javascript().execute("cm = arguments[0].CodeMirror;cm.focus();cm.setCursor(0, 0);const start = {ch: " + start + ", line: " + line + "};const end = {ch: " + end + ", line: " + line + "};cm.setSelection(start, end);", new Object[0]);
    }

    public T setText(String text) {
        String escapedText = text.replace("\n", "\\n").replace("\t", "\\t").replace("'", "\\'");
        PageElement codeMirror = this.elementFinder.find(By.className((String)"CodeMirror"));
        Poller.waitUntilTrue((TimedQuery)codeMirror.timed().isVisible());
        codeMirror.javascript().execute("cm = arguments[0].CodeMirror;cm.setValue('" + escapedText + "');cm.focus();cm.setCursor(cm.lineCount(), 0);", new Object[0]);
        return (T)this;
    }

    public T typeTextNatively(String text) {
        this.textArea.withTimeout(TimeoutType.UI_ACTION).click();
        this.textArea.type(new CharSequence[]{text});
        return (T)this;
    }
}

