/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.protocol;

import com.atlassian.bitbucket.scm.git.protocol.StreamAnalyzer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzingInputStream
extends FilterInputStream {
    private static final Logger log = LoggerFactory.getLogger(AnalyzingInputStream.class);
    private final StreamAnalyzer analyzer;

    public AnalyzingInputStream(InputStream delegate, StreamAnalyzer analyzer) {
        super(delegate);
        this.analyzer = analyzer;
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value != -1) {
            this.analyze(new byte[]{(byte)value}, 0, 1);
        }
        return value;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead > 0) {
            this.analyze(b, off, bytesRead);
        }
        return bytesRead;
    }

    private void analyze(byte[] b, int off, int len) {
        if (this.analyzer.isDone()) {
            return;
        }
        try {
            this.analyzer.process(b, off, len);
        }
        catch (RuntimeException e) {
            log.debug("Error analyzing input", (Throwable)e);
        }
    }
}

