/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.event;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
public class GitPullRequestRefsChangedEvent
extends ApplicationEvent {
    private final RefChange fromRefChange;
    private final RefChange mergeRefChange;
    private final long pullRequestId;
    private final Repository repository;

    public GitPullRequestRefsChangedEvent(@Nonnull Object source, @Nonnull Repository repository, long pullRequestId, @Nullable RefChange fromRefChange, @Nullable RefChange mergeRefChange) {
        super(source);
        this.fromRefChange = fromRefChange;
        this.mergeRefChange = mergeRefChange;
        this.repository = Objects.requireNonNull(repository, "repository");
        this.pullRequestId = pullRequestId;
    }

    @Nullable
    public RefChange getFromRefChange() {
        return this.fromRefChange;
    }

    @Nullable
    public RefChange getMergeRefChange() {
        return this.mergeRefChange;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public boolean hasFromRefChanged() {
        return this.fromRefChange != null;
    }

    public boolean hasMergeRefChanged() {
        return this.mergeRefChange != null;
    }
}

