/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InsightReportCondition;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InternalInsightMergeCheckService;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.SetInsightReportConditionRequest;
import com.atlassian.bitbucket.internal.codeinsights.rest.AbstractInsightResource;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReportCondition;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestSetInsightReportConditionRequest;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class BaseInsightReportConditionResource
extends AbstractInsightResource {
    InternalInsightMergeCheckService insightMergeCheckService;

    public BaseInsightReportConditionResource(I18nService i18nService, InternalInsightMergeCheckService insightMergeCheckService) {
        super(i18nService);
        this.insightMergeCheckService = insightMergeCheckService;
    }

    @DELETE
    @Path(value="{key}")
    public Response deleteInsightReportCondition(@BeanParam ScopeResolver scopeResolver, @PathParam(value="key") String reportKey) {
        this.validateReportKey(reportKey);
        this.insightMergeCheckService.delete(scopeResolver.getScope(), reportKey);
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="{key}")
    public Response getInsightReportCondition(@BeanParam ScopeResolver scopeResolver, @PathParam(value="key") String reportKey) {
        this.validateReportKey(reportKey);
        return this.insightMergeCheckService.getInsightReportCondition(scopeResolver.getScope(), reportKey).map(condition -> ResponseFactory.ok((Object)new RestInsightReportCondition((InsightReportCondition)condition)).build()).orElseGet(() -> ResponseFactory.notFound().build());
    }

    @GET
    public Response getInsightReportConditions(@BeanParam ScopeResolver scopeResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        return ResponseFactory.ok((Object)new RestPage(this.insightMergeCheckService.getInsightReportConditions(scopeResolver.getScope(), pageRequestResolver.getPageRequest()), RestInsightReportCondition::new)).build();
    }

    @PUT
    @Path(value="{key}")
    public Response setInsightReportCondition(@BeanParam ScopeResolver scopeResolver, @PathParam(value="key") String reportKey, RestSetInsightReportConditionRequest request) {
        this.validateReportKey(reportKey);
        InsightReportCondition condition = this.insightMergeCheckService.set(new SetInsightReportConditionRequest.Builder(StringUtils.stripToNull((String)reportKey), scopeResolver.getScope()).mustPass(request.isMustPass()).minimumProhibitedSeverity(request.getMinimumProhibitedSeverity()).build());
        return ResponseFactory.ok((Object)new RestInsightReportCondition(condition)).build();
    }

    private void validateReportKey(String reportKey) {
        if (StringUtils.isBlank((CharSequence)reportKey)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.codeinsights.mergecheck.error.reportkey.blank", new Object[0]));
        }
        if (StringUtils.length((CharSequence)reportKey) > 50) {
            throw new BadRequestException("key", this.i18nService.getMessage("bitbucket.rest.codeinsights.error.key.length", new Object[0]));
        }
    }
}

