/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.report;

import com.atlassian.bitbucket.internal.codeinsights.report.InternalInsightReportService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="insightReportCleanupJob")
public class InsightReportCleanupJob
implements LifecycleAware {
    static final String REPORTS_EXPIRY_DAYS = "plugin.bitbucket-code-insights.reports.expiry.days";
    static final int DEFAULT_REPORTS_EXPIRY_DAYS = 60;
    static final JobId JOB_ID = JobId.of((String)InsightReportCleanupJob.class.getSimpleName());
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)InsightReportCleanupJob.class.getName());
    private static final Logger log = LoggerFactory.getLogger(InsightReportCleanupJob.class);
    private final int reportsExpiryDays;
    private final InternalInsightReportService insightReportService;
    private final SchedulerService schedulerService;

    @Autowired
    public InsightReportCleanupJob(InternalInsightReportService insightReportService, ApplicationPropertiesService propertiesService, SchedulerService schedulerService) {
        this.insightReportService = insightReportService;
        this.schedulerService = schedulerService;
        this.reportsExpiryDays = propertiesService.getPluginProperty(REPORTS_EXPIRY_DAYS, 60);
    }

    public void onStart() {
        InsightReportCleanupJobRunner jobRunner = new InsightReportCleanupJobRunner();
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)jobRunner);
        try {
            Duration duration = Duration.ofDays(1L);
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)duration.toMillis(), (Date)Date.from(ZonedDateTime.now().plus(duration).toInstant()))));
        }
        catch (SchedulerServiceException e) {
            log.warn("Failed to schedule " + JOB_RUNNER_KEY, (Throwable)e);
        }
    }

    public void onStop() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @VisibleForTesting
    class InsightReportCleanupJobRunner
    implements JobRunner {
        InsightReportCleanupJobRunner() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            Date date = Date.from(ZonedDateTime.now().minusDays(InsightReportCleanupJob.this.reportsExpiryDays).toInstant());
            int numOfDeletedReports = InsightReportCleanupJob.this.insightReportService.deleteExpiredReports(date);
            log.info("Deleted '{}' code insight reports that were created before {}", (Object)numOfDeletedReports, (Object)date);
            return JobRunnerResponse.success();
        }
    }
}

