/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.mergecheck;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.dao.InsightMergeCheckSettingsDao;
import com.atlassian.bitbucket.internal.codeinsights.event.InsightReportConditionAddedEvent;
import com.atlassian.bitbucket.internal.codeinsights.event.InsightReportConditionDeletedEvent;
import com.atlassian.bitbucket.internal.codeinsights.event.InsightReportConditionUpdatedEvent;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InsightReportCondition;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InternalInsightMergeCheckService;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InternalInsightReportCondition;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.SetInsightReportConditionRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="insightMergeCheckService")
public class DefaultInsightMergeCheckService
implements InternalInsightMergeCheckService {
    private static final int REPORT_KEY_LENGTH = 50;
    private final InsightMergeCheckSettingsDao dao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;

    public DefaultInsightMergeCheckService(I18nService i18nService, InsightMergeCheckSettingsDao dao, EventPublisher eventPublisher, PermissionValidationService permissionValidationService, ProjectService projectService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.permissionValidationService = permissionValidationService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
    }

    @Override
    public void delete(@Nonnull Scope scope, @Nonnull String reportKey) {
        this.verifyAdminPermissions(Objects.requireNonNull(scope));
        reportKey = this.verifyReportKey(reportKey);
        this.dao.get(DefaultInsightMergeCheckService.getResourceId(scope), scope.getType(), reportKey).ifPresent(existing -> {
            this.dao.delete(existing.getID());
            this.eventPublisher.publish((Object)new InsightReportConditionDeletedEvent(this, existing.initialize(scope)));
        });
    }

    @Override
    @Nonnull
    public Optional<InsightReportCondition> getInsightReportCondition(@Nonnull Scope scope, @Nonnull String reportKey) {
        this.verifyViewPermissions(Objects.requireNonNull(scope));
        if (scope.getType() == ScopeType.GLOBAL) {
            return Optional.empty();
        }
        reportKey = this.verifyReportKey(reportKey);
        return this.dao.get(DefaultInsightMergeCheckService.getResourceId(scope), scope.getType(), reportKey).map(condition -> condition.initialize(scope));
    }

    @Override
    @Nonnull
    public Page<InsightReportCondition> getInsightReportConditions(final @Nonnull Scope scope, final @Nonnull PageRequest pageRequest) {
        this.verifyViewPermissions(Objects.requireNonNull(Objects.requireNonNull(scope, "scope")));
        Objects.requireNonNull(pageRequest, "pageRequest");
        if (scope.getType() == ScopeType.GLOBAL) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return (Page)scope.accept((ScopeVisitor)new ScopeVisitor<Page<InsightReportCondition>>(){

            public Page<InsightReportCondition> visit(@Nonnull ProjectScope projectScope) {
                return DefaultInsightMergeCheckService.this.dao.findForProject(DefaultInsightMergeCheckService.getResourceId(scope), pageRequest).transform(condition -> condition.initialize(scope));
            }

            public Page<InsightReportCondition> visit(@Nonnull RepositoryScope repositoryScope) {
                ProjectScope projectScope = Scopes.project((Project)repositoryScope.getProject());
                return DefaultInsightMergeCheckService.this.dao.findForRepository(DefaultInsightMergeCheckService.getResourceId((Scope)projectScope), DefaultInsightMergeCheckService.getResourceId((Scope)repositoryScope), pageRequest).transform(arg_0 -> 1.lambda$visit$1((Scope)projectScope, repositoryScope, arg_0));
            }

            private static /* synthetic */ InsightReportCondition lambda$visit$1(Scope projectScope, RepositoryScope repositoryScope, InternalInsightReportCondition condition) {
                return condition.initialize((Scope)(condition.getScopeType() == ScopeType.PROJECT ? projectScope : repositoryScope));
            }
        });
    }

    @Override
    @Nonnull
    public InsightReportCondition set(@Nonnull SetInsightReportConditionRequest setRequest) {
        this.verifyAdminPermissions(Objects.requireNonNull(setRequest).getScope());
        Integer resourceId = DefaultInsightMergeCheckService.getResourceId(setRequest.getScope());
        String reportKey = this.verifyReportKey(setRequest.getReportKey());
        ScopeType scopeType = setRequest.getScope().getType();
        Optional<InternalInsightReportCondition> existingCondition = this.dao.get(resourceId, scopeType, reportKey);
        existingCondition.ifPresent(existing -> this.dao.delete(existing.getID()));
        InternalInsightReportCondition internalCondition = this.dao.create(resourceId, scopeType, reportKey, setRequest.getMinimumProhibitedSeverity().orElse(null), setRequest.isMustPass());
        InsightReportCondition condition = internalCondition.initialize(this.convertToScope());
        if (existingCondition.isPresent()) {
            this.eventPublisher.publish((Object)new InsightReportConditionUpdatedEvent(this, existingCondition.get().initialize(this.convertToScope()), condition));
        } else {
            this.eventPublisher.publish((Object)new InsightReportConditionAddedEvent(this, condition));
        }
        return condition;
    }

    private static Integer getResourceId(@Nonnull Scope scope) {
        return (Integer)scope.getResourceId().orElseThrow(() -> new IllegalStateException("All project and repository scopes should have a resource ID"));
    }

    private BiFunction<Integer, ScopeType, Scope> convertToScope() {
        return (resourceId, scopeType) -> {
            switch (scopeType) {
                case REPOSITORY: {
                    Repository repository = this.repositoryService.getById(resourceId.intValue());
                    if (repository == null) {
                        throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.repo.notexist", new Object[]{resourceId}), null);
                    }
                    return Scopes.repository((Repository)repository);
                }
                case PROJECT: {
                    Project project = this.projectService.getById(resourceId.intValue());
                    if (project == null) {
                        throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.project.notexist", new Object[]{resourceId}));
                    }
                    return Scopes.project((Project)project);
                }
                case GLOBAL: {
                    return Scopes.global();
                }
            }
            throw new IllegalArgumentException("Unexpected scope: " + scopeType);
        };
    }

    private void verifyAdminPermissions(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                throw new IllegalArgumentException("The merge check can only be configured at a project and repository level");
            }

            public Void visit(@Nonnull ProjectScope scope) {
                DefaultInsightMergeCheckService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultInsightMergeCheckService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private String verifyReportKey(@Nonnull String reportKey) {
        if ((reportKey = Objects.requireNonNull(StringUtils.stripToNull((String)reportKey), "reportKey").toLowerCase(Locale.US)).length() > 50) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.mergecheck.error.reportkey.length", new Object[0]));
        }
        return reportKey;
    }

    private void verifyViewPermissions(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                DefaultInsightMergeCheckService.this.permissionValidationService.validateAuthenticated();
                return null;
            }

            public Void visit(@Nonnull ProjectScope scope) {
                DefaultInsightMergeCheckService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_VIEW);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultInsightMergeCheckService.this.permissionValidationService.validateRepositoryAccessible(scope.getRepository());
                return null;
            }
        });
    }
}

