/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.dao;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.ShaUtils;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SetInsightReportParameters {
    private final Integer authorId;
    private final String commitId;
    private final String coverageProviderKey;
    private final Date createdDate;
    private final String data;
    private final String details;
    private final String key;
    private final String link;
    private final String logoUrl;
    private final String reporter;
    private final Integer repositoryId;
    private final Integer resultId;
    private final String title;

    private SetInsightReportParameters(@Nonnull Builder builder) {
        this.authorId = builder.authorId;
        this.commitId = builder.commitId;
        this.coverageProviderKey = builder.coverageProviderKey;
        this.createdDate = builder.createdDate;
        this.data = builder.data;
        this.details = builder.details;
        this.key = builder.key;
        this.link = builder.link;
        this.logoUrl = builder.logoUrl;
        this.repositoryId = builder.repositoryId;
        this.resultId = builder.resultId;
        this.title = builder.title;
        this.reporter = builder.reporter;
    }

    @Nullable
    public Integer getAuthorId() {
        return this.authorId;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nullable
    public String getCoverageProviderKey() {
        return this.coverageProviderKey;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    public String getData() {
        return this.data;
    }

    @Nullable
    public String getDetails() {
        return this.details;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getLink() {
        return this.link;
    }

    @Nullable
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @Nonnull
    public String getReporter() {
        return this.reporter;
    }

    @Nonnull
    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    @Nullable
    public Integer getResultId() {
        return this.resultId;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public static final class Builder
    extends BuilderSupport {
        private Integer authorId;
        private final String commitId;
        private final String key;
        private final Integer repositoryId;
        private final String title;
        private String coverageProviderKey;
        private Date createdDate;
        private String data;
        private String details;
        private String link;
        private String logoUrl;
        private String reporter;
        private Integer resultId;

        public Builder(@Nonnull String commitId, @Nonnull String key, @Nonnull Repository repository, @Nonnull String title) {
            Preconditions.checkArgument((boolean)ShaUtils.PATTERN_HASH.matcher(commitId).matches(), (Object)"commitId");
            this.commitId = commitId;
            this.key = Builder.requireNonBlank((String)key, (String)"key");
            this.repositoryId = Objects.requireNonNull(repository, "repository").getId();
            this.title = Builder.requireNonBlank((String)title, (String)"title");
            this.createdDate = new Date();
        }

        @Nonnull
        public SetInsightReportParameters build() {
            return new SetInsightReportParameters(this);
        }

        @Nonnull
        public Builder coverageProviderKey(@Nullable String value) {
            this.coverageProviderKey = value;
            return this;
        }

        @Nonnull
        public Builder data(@Nullable String value) {
            this.data = value;
            return this;
        }

        @Nonnull
        public Builder details(@Nullable String value) {
            this.details = value;
            return this;
        }

        @Nonnull
        public Builder link(@Nullable String value) {
            this.link = value;
            return this;
        }

        @Nonnull
        public Builder logoUrl(@Nullable String value) {
            this.logoUrl = value;
            return this;
        }

        @Nonnull
        public Builder reporter(@Nullable String value) {
            this.reporter = value;
            return this;
        }

        @Nonnull
        public Builder resultId(@Nullable Integer value) {
            this.resultId = value;
            return this;
        }

        @Nonnull
        public Builder authorId(@Nullable Integer authorId) {
            this.authorId = authorId;
            return this;
        }
    }
}

