/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.annotation;

import com.atlassian.bitbucket.compare.CompareDiffRequest;
import com.atlassian.bitbucket.compare.CompareRef;
import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.internal.codeinsights.annotation.ChangedLinesCacheKey;
import com.atlassian.bitbucket.internal.codeinsights.annotation.FileChanges;
import com.atlassian.bitbucket.internal.codeinsights.annotation.LineRange;
import com.atlassian.bitbucket.internal.codeinsights.annotation.PullRequestAnnotationHelper;
import com.atlassian.bitbucket.internal.codeinsights.annotation.SourceDiff;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.compare.CompareDiffCommandParameters;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.springframework.stereotype.Component;

@Component
public class DefaultPullRequestAnnotationHelper
implements PullRequestAnnotationHelper {
    static final int DIFF_CACHE_MAX_DEFAULT = 500;
    static final String DIFF_CACHE_MAX_PROP = "plugin.bitbucket-code-insights.pullrequest.changedlines.cache.max";
    static final long DIFF_CACHE_TTL_DEFAULT = 7200L;
    static final String DIFF_CACHE_TTL_PROP = "plugin.bitbucket-code-insights.pullrequest.changedlines.cache.ttl";
    static final String SOURCE_CACHE_NAME = "com.atlassian.bitbucket.internal.codeinsights.annotation.DefaultInsightAnnotationService.sourceDiffCache";
    private static final int DEFAULT_PULL_REQUEST_DIFF_MAX_LINE_LENGTH = 5000;
    private static final int MAX_LINES = 20000;
    private static final String PULL_REQUEST_DIFF_MAX_LINE_LENGTH = "plugin.bitbucket-code-insights.pr.diff.linelength.max";
    private final int maxPullRequestDiffLineLength;
    private final ScmService scmService;
    private final Cache<ChangedLinesCacheKey, SourceDiff> sourceDiffCache;

    public DefaultPullRequestAnnotationHelper(ApplicationPropertiesService propertiesService, CacheFactory cacheFactory, ScmService scmService) {
        this.scmService = scmService;
        this.sourceDiffCache = this.getSourceDiffCache(propertiesService, cacheFactory);
        this.maxPullRequestDiffLineLength = propertiesService.getPluginProperty(PULL_REQUEST_DIFF_MAX_LINE_LENGTH, 5000);
    }

    @Override
    @Nonnull
    public SourceDiff getSourceDiff(@Nonnull PullRequest pullRequest, @Nonnull Set<String> requestedPaths) {
        SourceDiff sourceDiff = (SourceDiff)this.sourceDiffCache.get((Object)new ChangedLinesCacheKey(pullRequest), () -> this.calculateDiff(pullRequest));
        if (!requestedPaths.isEmpty()) {
            MutableBoolean filteredTruncated = new MutableBoolean();
            Map<String, FileChanges> filteredFileChanges = sourceDiff.getFileChanges().entrySet().stream().filter(entry -> requestedPaths.contains(entry.getKey())).peek(entry -> {
                if (((FileChanges)entry.getValue()).isTruncated()) {
                    filteredTruncated.setTrue();
                }
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (sourceDiff.isTruncated() && filteredFileChanges.size() != requestedPaths.size()) {
                filteredTruncated.setTrue();
            }
            sourceDiff = filteredTruncated.booleanValue() ? this.calculateDiff(pullRequest, requestedPaths) : new SourceDiff.Builder().fileChanges(filteredFileChanges).truncated(false).build();
        }
        return sourceDiff;
    }

    @EventListener
    public void onPullRequestRescopedEvent(PullRequestRescopedEvent event) {
        if (event.isFromHashUpdated() || event.getAddedCommits() != null && event.getAddedCommits().getTotal() > 0 || event.getRemovedCommits() != null && event.getRemovedCommits().getTotal() > 0) {
            this.sourceDiffCache.remove((Object)new ChangedLinesCacheKey(event.getPullRequest().getToRef().getRepository().getId(), event.getPullRequest().getId(), event.getPreviousFromHash()));
        }
    }

    private SourceDiff calculateDiff(PullRequest pullRequest) {
        return this.calculateDiff(pullRequest, Collections.emptySet());
    }

    private SourceDiff calculateDiff(PullRequest pullRequest, Iterable<String> paths) {
        final SourceDiff.Builder diffBuilder = new SourceDiff.Builder();
        try (Timer ignored = TimerUtils.start((String)("Getting source changes for PR " + pullRequest.getId() + " in repository " + pullRequest.getToRef().getRepository()));){
            CompareRequest mergeBaseDiffRequest = new CompareRequest.Builder(new CompareDiffRequest.Builder().fromRef(new CompareRef(pullRequest.getFromRef().getLatestCommit(), pullRequest.getFromRef().getRepository())).toRef(new CompareRef(pullRequest.getToRef().getLatestCommit(), pullRequest.getToRef().getRepository())).build()).build();
            CompareDiffCommandParameters mergeBaseDiffCommandParameters = ((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)new CompareDiffCommandParameters.Builder().paths(paths)).contextLines(0)).maxLines(20000)).maxLineLength(this.maxPullRequestDiffLineLength)).build();
            this.scmService.getCompareCommandFactory(mergeBaseDiffRequest).diff(mergeBaseDiffCommandParameters, (DiffContentCallback)new AbstractDiffContentCallback(){
                private FileChanges.Builder changesBuilder;
                private String path;

                public void onBinary(@Nullable Path src, @Nullable Path dst) {
                    this.addFile(dst);
                    this.onFileEnd();
                }

                public void onDiffEnd(boolean truncated) {
                    if (this.changesBuilder == null) {
                        return;
                    }
                    if (truncated) {
                        this.changesBuilder.truncated(true);
                        diffBuilder.truncated(true);
                    }
                    this.onFileEnd();
                }

                public void onDiffStart(@Nullable Path src, @Nullable Path dst) {
                    this.addFile(dst);
                }

                public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan, @Nullable String context) {
                    if (this.changesBuilder == null) {
                        return;
                    }
                    this.changesBuilder.addLineRange(LineRange.between(dstLine, dstLine - 1 + dstSpan));
                }

                private void addFile(@Nullable Path dst) {
                    if (dst == null) {
                        this.changesBuilder = null;
                        this.path = null;
                    } else {
                        this.changesBuilder = new FileChanges.Builder();
                        this.path = dst.toString();
                    }
                }

                private void onFileEnd() {
                    if (this.changesBuilder == null) {
                        return;
                    }
                    diffBuilder.fileChange(this.path, this.changesBuilder.build());
                    this.changesBuilder = null;
                    this.path = null;
                }
            }).call();
        }
        return diffBuilder.build();
    }

    private Cache<ChangedLinesCacheKey, SourceDiff> getSourceDiffCache(ApplicationPropertiesService propertiesService, CacheFactory cacheFactory) {
        return cacheFactory.getCache(SOURCE_CACHE_NAME, null, new CacheSettingsBuilder().local().expireAfterAccess(propertiesService.getPluginProperty(DIFF_CACHE_TTL_PROP, 7200L), TimeUnit.SECONDS).maxEntries(propertiesService.getPluginProperty(DIFF_CACHE_MAX_PROP, 500)).build());
    }
}

