/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.coverage.CodeCoverageService;
import com.atlassian.bitbucket.internal.codeinsights.rest.JsonCodeCoverageCallback;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/coverage")
public class PullRequestCodeCoverageResource {
    private final CodeCoverageService coverageService;
    private final I18nService i18nService;

    @Inject
    public PullRequestCodeCoverageResource(CodeCoverageService coverageService, I18nService i18nService) {
        this.coverageService = coverageService;
        this.i18nService = i18nService;
    }

    @GET
    @Path(value="{path:.*}")
    public Response getFileCoverage(final @BeanParam PullRequestResolver pullRequestResolver, final @PathParam(value="path") String path, final @BeanParam PageRequestResolver pageRequestResolver) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.codeinsights.coverage.path.required", new Object[0]));
        }
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                PullRequestCodeCoverageResource.this.coverageService.streamCoverage(pullRequestResolver.getPullRequest(), path, new JsonCodeCoverageCallback(writer, pageRequestResolver.getPageRequest()), pageRequestResolver.getPageRequest());
            }
        }).build();
    }
}

