define('bitbucket-plugin-code-insights/internal/summary-link/summary-link-container', ['exports', 'lodash', 'react', 'react-redux', 'reselect', '../feature-discovery/feature-discovery', '../report', '../state/report-state', './summary-link'], function (exports, _lodash, _react, _reactRedux, _reselect, _featureDiscovery, _report, _reportState, _summaryLink) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.makeMapStateToProps = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _summaryLink2 = _interopRequireDefault(_summaryLink);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    var _resultRank;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var resultRank = (_resultRank = {}, _defineProperty(_resultRank, _report.ResultEnum.FAIL, 0), _defineProperty(_resultRank, _report.ResultEnum.PASS, 1), _defineProperty(_resultRank, 'null', 2), _resultRank);

    var pullRequestSelector = function pullRequestSelector(state, props) {
        return props.pullRequest;
    };

    //@VisibleForTesting
    var makeMapStateToProps = exports.makeMapStateToProps = function makeMapStateToProps() {
        var _selectors = (0, _reportState.selectors)(pullRequestSelector),
            reportsSelector = _selectors.reportsSelector,
            allReportsLoadedSelector = _selectors.allReportsLoadedSelector,
            areReportsLoadingSelector = _selectors.areReportsLoadingSelector;

        // get an array of [result, resultCount] pairs, sorted FAIL, PASS, (no result)


        var primaryResultCountsSelector = (0, _reselect.createSelector)(reportsSelector, function (reports) {
            return (0, _lodash.chain)(reports).groupBy(function (report) {
                return report.result || '';
            }).map(function (values, result) {
                return [result || null, values.length];
            }).sortBy(function (_ref) {
                var _ref2 = _slicedToArray(_ref, 1),
                    result = _ref2[0];

                return resultRank[result];
            }).first().value() || [null, 0];
        });

        return (0, _reselect.createSelector)(allReportsLoadedSelector, areReportsLoadingSelector, reportsSelector, primaryResultCountsSelector, function (allFetched, loading, reports, _ref3) {
            var _ref4 = _slicedToArray(_ref3, 2),
                result = _ref4[0],
                resultCount = _ref4[1];

            return {
                allFetched: allFetched,
                loading: loading,
                reportCount: reports.length,
                onlyReport: reports.length === 1 ? reports[0] : null,
                result: result,
                resultCount: resultCount
            };
        });
    };

    var mapDispatchToProps = {
        loadReports: _reportState.actionCreators.loadReports
    };

    var SummaryLinkContainer = function (_PureComponent) {
        _inherits(SummaryLinkContainer, _PureComponent);

        function SummaryLinkContainer() {
            _classCallCheck(this, SummaryLinkContainer);

            return _possibleConstructorReturn(this, (SummaryLinkContainer.__proto__ || Object.getPrototypeOf(SummaryLinkContainer)).apply(this, arguments));
        }

        _createClass(SummaryLinkContainer, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _props = this.props,
                    allFetched = _props.allFetched,
                    reportCount = _props.reportCount,
                    loading = _props.loading,
                    loadReports = _props.loadReports,
                    pullRequest = _props.pullRequest;

                if (!(allFetched || reportCount || loading)) {
                    loadReports({ pullRequest: pullRequest });
                }
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps) {
                var _props2 = this.props,
                    allFetched = _props2.allFetched,
                    reportCount = _props2.reportCount;

                /*
                 * If there are reports then show the firstUse feature discovery
                 * If there are no reports then show the initial feature discovery
                 */
                if (!prevProps.allFetched && allFetched) {
                    if (reportCount > 0) {
                        (0, _featureDiscovery.firstUseFeatureDiscovery)();
                    } else {
                        (0, _featureDiscovery.initialFeatureDiscovery)();
                    }
                }
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(_summaryLink2.default, this.props);
            }
        }]);

        return SummaryLinkContainer;
    }(_react.PureComponent);

    exports.default = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps)(SummaryLinkContainer);
});