define('bitbucket-plugin-code-insights/internal/state/report-state', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/rest-actor', 'bitbucket/internal/util/store/reducers', './insight-shared-state', './insight-state-utils'], function (exports, _lodash, _redux, _reselect, _navbuilder, _restActor, _reducers, _insightSharedState, _insightStateUtils) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.reducers = exports.selectors = exports.actors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var LOAD_REPORTS = 'LOAD_REPORTS';
    var LOAD_REPORTS_SUCCESS = 'LOAD_REPORTS_SUCCESS';
    var LOAD_REPORTS_FAILURE = 'LOAD_REPORTS_FAILURE';

    var EMPTY_ARRAY = [];

    var actionCreators = exports.actionCreators = {
        loadReports: function loadReports(_ref) {
            var pullRequest = _ref.pullRequest,
                commit = _ref.commit;
            return {
                type: LOAD_REPORTS,
                payload: {
                    pullRequest: pullRequest,
                    commit: commit
                },
                meta: {
                    successType: LOAD_REPORTS_SUCCESS,
                    failureType: LOAD_REPORTS_FAILURE
                }
            };
        }
    };

    var actors = exports.actors = [(0, _restActor.restActorForType)(LOAD_REPORTS, function (action) {
        return {
            url: _navbuilder2.default.rest('insights').pullRequest(action.payload.pullRequest).addPathComponents('reports').build(),
            statusCode: {
                '*': false
            }
        };
    })];

    var EMPTY_OBJECT = {};

    var selectors = exports.selectors = function selectors(pullRequestSelector, sourceCommitSelector) {
        var _globalSelectors = (0, _insightSharedState.selectors)(pullRequestSelector),
            reportStateSelector = _globalSelectors.reportStateSelector,
            reportRequestsStateSelector = _globalSelectors.reportRequestsStateSelector,
            scSelector = _globalSelectors.sourceCommitSelector;
        // they can provide a sourceCommitSelector, but if they don't we use the newest source commit we've gotten from the server.


        sourceCommitSelector = sourceCommitSelector || scSelector;

        var areReportsLoadingSelector = function areReportsLoadingSelector(state, props) {
            return (0, _lodash.get)(reportRequestsStateSelector(state, props), 'loading', false);
        };

        var allReportsLoadedSelector = (0, _reselect.createSelector)(reportStateSelector, sourceCommitSelector, function (reportStateBySourceCommit, sourceCommit) {
            return (0, _lodash.get)(reportStateBySourceCommit, [sourceCommit, 'paging', 'lastPageMeta', 'isLastPage'], false);
        });

        var reportsByIdSelector = (0, _reselect.createSelector)(reportStateSelector, sourceCommitSelector, function (reportStateBySourceCommit, sourceCommit) {
            return (0, _lodash.get)(reportStateBySourceCommit, [sourceCommit, 'entities'], EMPTY_OBJECT);
        });

        var reportsSelector = (0, _reselect.createSelector)(reportStateSelector, sourceCommitSelector, reportsByIdSelector, function (reportStateBySourceCommit, sourceCommit, reportsById) {
            var ids = (0, _lodash.get)(reportStateBySourceCommit, [sourceCommit, 'paging', 'ids']);
            return ids ? ids.map(function (id) {
                return reportsById[id];
            }) : EMPTY_ARRAY;
        });

        return {
            allReportsLoadedSelector: allReportsLoadedSelector,
            areReportsLoadingSelector: areReportsLoadingSelector,
            reportsByIdSelector: reportsByIdSelector,
            reportsSelector: reportsSelector
        };
    };

    // In some cases we key our state tree by a PR's source commit
    // this is so that if the source commit changes, we pull in new data.
    // This is a SAFE action for reports, which only change with the source commit
    // This is an UNSAFE action for annotations, which _could_ be outdated by changes
    // on the target branch. However, for annotations in the modal, we accept this limitation
    // for two reasons:
    // - we don't have access to the merge commit (it's not on the PR and isn't returned with annotations)
    //   so we'd need extra requests to check against it.
    // - people aren't looking at the diff so they're unlikely to see the conflict anyway
    // For annotations on diffs, we have a merge commit to compare against and use it.
    var versionBySourceCommit = (0, _reducers.versionBy)(function (_ref2) {
        var type = _ref2.type,
            payload = _ref2.payload,
            meta = _ref2.meta;

        switch (type) {
            case LOAD_REPORTS_SUCCESS:
            case LOAD_REPORTS_FAILURE:
                return (
                    // Note that since we no longer request report data at the given commit,
                    // we have a race condition here where we could be applying the result of the request
                    // to the wrong commit. In the case of grabbing reports for annotations on a given path,
                    // the request is made immediately after the annotation request, so the window for the race condition is small.
                    // We accept this cost to simplify the implementation of the PR REST resources on the backend which can now always get the
                    // latest commit information.
                    meta.originalAction.payload.commit || (0, _insightStateUtils.getPRSourceCommit)(meta.originalAction.payload.pullRequest)
                );
        }
    }, 'commit');

    var getReportId = function getReportId(report) {
        return report.key;
    };

    var reducers = exports.reducers = {
        reports: versionBySourceCommit((0, _redux.combineReducers)({
            entities: (0, _reducers.entitiesReducer)({ loadPageSuccess: LOAD_REPORTS_SUCCESS }, getReportId),
            paging: (0, _reducers._legacyPagingReducer)(LOAD_REPORTS_SUCCESS, getReportId)
        })),
        requests: (0, _insightStateUtils.requestsReducer)(LOAD_REPORTS, LOAD_REPORTS_SUCCESS, LOAD_REPORTS_FAILURE)
    };
});